/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework;

import com.auto.framework.TestComponentData;
import com.auto.framework.check.Check;
import com.auto.framework.iface.ITestComponent;
import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.Operation;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.utils.ThreadUtils;

public abstract class AbstractTestComponent
implements ITestComponent {
    private final int port;
    private final String host;
    private final String logDir;
    private static final int NUMBER_OF_TIMES_TRY_TO_START = 5;
    private final String server;
    private String installationDir;

    protected AbstractTestComponent(TestComponentData data) {
        this.host = data.getHost();
        this.port = data.getPort();
        this.logDir = data.getLogDir();
        this.server = data.getServer();
        this.installationDir = data.getInstallationDir();
    }

    @Override
    public void start() {
        TestReporter.TRACE("Starting component " + this);
        this.executeStartOperation();
        TestReporter.TRACE("Component started " + this);
    }

    @Override
    public void stop() {
        this.performStopOperation();
        this.verifyProcessStopped();
    }

    protected void executeStartOperation() {
        Operation op = this.getStartOperation();
        int tried = 0;
        do {
            if (tried > 0) {
                ThreadUtils.sleep(1L);
            }
            this.performOperation(op);
        } while (!this.isRunning() && ++tried < 5);
        if (!this.isRunning()) {
            TestReporter.FATAL("Couldn't start component " + this + "\n" + op.getResult());
        }
    }

    protected void performStopOperation() {
        TestReporter.TRACE("Stopping component " + this);
        Operation op = this.getStopOperation();
        this.performOperation(op);
    }

    public void verifyProcessStopped() {
        Check.assertBusyWait(b -> this.isRunning(), () -> "", 4, 3, "Unable to stop component");
        TestReporter.TRACE("Component stopped " + this);
    }

    public final OpResult performOperation(Operation oOperation) {
        oOperation.execute();
        return oOperation.getResult();
    }

    public OpResult performFailedOperation(Operation oOperation) {
        OpResult result = this.performOperation(oOperation);
        if (result.getExitStatus() == 0) {
            TestReporter.FAIL("Succeeded to perform " + oOperation.getName() + "operation when should have failed. Command result: " + result);
        }
        return result;
    }

    public OpResult performSuccessOperation(Operation oOperation) {
        OpResult result = this.performOperation(oOperation);
        if (result.getExitStatus() != 0) {
            TestReporter.FAIL("Failed to perform ('" + oOperation.getName() + "') operation when should have succeeded. Command result: " + result);
        }
        return result;
    }

    protected abstract Operation getStartOperation();

    protected abstract Operation getStopOperation();

    @Override
    public void restart() {
        this.stop();
        this.verifyProcessStopped();
        this.start();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getLogDir() {
        return this.logDir;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getComponentName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Integer getCleanOrder() {
        return 0;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getInstallationDir() {
        return this.installationDir;
    }
}

