/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.runner.CommandProcess;
import com.auto.framework.utils.ThreadMonitor;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CommandRunner {
    private final Map<String, String> envVariable;
    private CommandResult commandResult;
    private String installationDir;
    private long commandTimeout = 60000L;

    public CommandRunner(Map<String, String> env) {
        this.envVariable = env;
    }

    public CommandRunner(Map<String, String> env, String installationDir, long commandTimeout) {
        this.envVariable = env;
        this.installationDir = installationDir;
        this.commandTimeout = commandTimeout;
    }

    @Deprecated
    public void runCommandOld(CommandRequest commandRequest) {
        long startTime = System.currentTimeMillis();
        File wd = null;
        if (StringUtils.isNotEmpty((CharSequence)this.installationDir)) {
            wd = new File(this.installationDir);
        }
        String[] environment = null;
        if (MapUtils.isNotEmpty(this.envVariable)) {
            environment = (String[])this.envVariable.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new);
        }
        try {
            ByteArrayOutputStream ourStream = new ByteArrayOutputStream();
            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
            FutureTask<Integer> task = new FutureTask<Integer>(new CommandProcess(commandRequest.getCommand(), environment, wd, ourStream, errorStream));
            Thread t = new Thread(task);
            t.start();
            Integer integer = task.get(this.commandTimeout, TimeUnit.SECONDS);
            Iterable iterableOut = Splitter.on((String)System.getProperty("line.separator")).split((CharSequence)new String(ourStream.toByteArray()));
            Iterable iterableErr = Splitter.on((String)System.getProperty("line.separator")).split((CharSequence)new String(ourStream.toByteArray()));
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(integer, Lists.newArrayList((Iterable)iterableOut), Lists.newArrayList((Iterable)iterableErr), timeTaken);
        }
        catch (Exception e) {
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(-1, Collections.emptyList(), Lists.newArrayList((Object[])new String[]{e.getMessage()}), timeTaken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(CommandRequest commandRequest) {
        long startTime = System.currentTimeMillis();
        String[] command = commandRequest.getCommand();
        File wd = null;
        if (StringUtils.isNotEmpty((CharSequence)this.installationDir)) {
            wd = new File(this.installationDir);
        }
        String[] environment = null;
        if (MapUtils.isNotEmpty(this.envVariable)) {
            environment = (String[])this.envVariable.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).toArray(String[]::new);
        }
        ArrayList listsResult = Lists.newArrayList();
        ArrayList listsError = Lists.newArrayList();
        Process process = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        InputStream errorStream = null;
        InputStreamReader errorStreamReader = null;
        OutputStream outputStream = null;
        try {
            String error;
            String line;
            Thread monitor = ThreadMonitor.start(this.commandTimeout);
            process = Runtime.getRuntime().exec(command, environment, wd);
            outputStream = process.getOutputStream();
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            while ((line = reader.readLine()) != null) {
                listsResult.add(line);
            }
            errorStream = process.getErrorStream();
            errorStreamReader = new InputStreamReader(errorStream);
            reader = new BufferedReader(errorStreamReader);
            while ((error = reader.readLine()) != null) {
                listsError.add(error);
            }
            int exitVal = process.waitFor();
            ThreadMonitor.stop(monitor);
            long endTime = System.currentTimeMillis();
            long timeTaken = endTime - startTime;
            this.commandResult = new CommandResult(exitVal, listsResult, listsError, timeTaken);
        }
        catch (Exception e) {
            try {
                long endTime = System.currentTimeMillis();
                long timeTaken = endTime - startTime;
                this.commandResult = new CommandResult(-1, Collections.emptyList(), Lists.newArrayList((Object[])new String[]{e.getMessage()}), timeTaken);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(inputStreamReader);
                IOUtils.closeQuietly(errorStream);
                IOUtils.closeQuietly(errorStreamReader);
                IOUtils.closeQuietly(outputStream);
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((Reader)inputStreamReader);
            IOUtils.closeQuietly(errorStream);
            IOUtils.closeQuietly(errorStreamReader);
            IOUtils.closeQuietly((OutputStream)outputStream);
            if (process != null) {
                process.destroy();
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Reader)inputStreamReader);
        IOUtils.closeQuietly((InputStream)errorStream);
        IOUtils.closeQuietly((Reader)errorStreamReader);
        IOUtils.closeQuietly((OutputStream)outputStream);
        if (process != null) {
            process.destroy();
        }
    }

    private String[] addFirst(String[] command, String element) {
        String[] arr = new String[command.length + 1];
        arr[0] = element;
        System.arraycopy(command, 0, arr, 1, command.length);
        return arr;
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public Map<String, String> getEnvVariable() {
        return this.envVariable;
    }
}

