/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.exception.JavaException;
import com.qa.automation.utils.java.utils.params.CommonParams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class JsonOprs {
    private FileInputStream fileInputStream;
    private Workbook workbook;
    private DataFormatter formatter = new DataFormatter();

    public void saveJsonFile(JsonObject jsonObject, String jsonFilePath) {
        FileOprs fileOprs = new FileOprs();
        fileOprs.createDirectory(fileOprs.getDirectoryPathFromFilePath(jsonFilePath));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFilePath), Charset.forName(CommonParams.CONTENT_ENCODING_TYPE));){
            writer.write(gson.toJson((JsonElement)jsonObject));
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
    }

    public void saveJsonFile(String jsonString, String jsonFilePath) {
        this.saveJsonFile(this.stringToJsonObject(jsonString), jsonFilePath);
    }

    public String formatJsonString(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
        return this.formatJsonObject(jsonObject);
    }

    public String formatJsonObject(JsonObject jsonObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    public String formatJsonArrayString(String jsonArrayString) {
        JsonArray jsonArray = JsonParser.parseString((String)jsonArrayString).getAsJsonArray();
        return this.formatJsonArrayObject(jsonArray);
    }

    public String formatJsonArrayObject(JsonArray jsonArrayObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonArrayObject);
    }

    public JsonObject stringToJsonObject(String jsonString) {
        JsonObject jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
        return jsonObject;
    }

    public String jsonObjectToString(JsonObject jsonObject) {
        return this.formatJsonObject(jsonObject);
    }

    public JsonArray stringToJsonArray(String jsonArrayString) {
        JsonElement jsonElement = JsonParser.parseString((String)jsonArrayString);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        return jsonArray;
    }

    public JsonArray stringArrayListToJsonArray(List<String> arrayList) {
        JsonArray jsonArray = new JsonArray();
        for (String arrayListElement : arrayList) {
            jsonArray.add(arrayListElement);
        }
        return jsonArray;
    }

    public JsonObject mapToJsonObject(Map<String, Object> map) {
        return this.stringToJsonObject(this.mapToJsonString(map));
    }

    public String mapToJsonString(Map<String, Object> map) {
        Gson gson = new Gson();
        return gson.toJson(map);
    }

    public void printJsonString(String jsonString) {
        System.out.println(this.formatJsonString(jsonString));
    }

    public void printJsonObject(JsonObject jsonObject) {
        System.out.println(this.formatJsonObject(jsonObject));
    }

    public void printJsonArrayObject(JsonArray jsonArrayObject) {
        System.out.println(this.formatJsonArrayObject(jsonArrayObject));
    }

    public void printJsonArrayString(String jsonArrayString) {
        this.printJsonArrayObject(this.stringToJsonArray(jsonArrayString));
    }

    public boolean existStringInStringsJsonArray(String string, JsonArray jsonArray) {
        boolean response = false;
        for (JsonElement jsonElement : jsonArray) {
            if (!jsonElement.getAsString().equalsIgnoreCase(string)) continue;
            response = true;
            break;
        }
        return response;
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(String excelDataFilePath) {
        return this.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(excelDataFilePath, false);
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(String excelDataFilePath, boolean trimCellValues) {
        JsonObject jsonObject = new JsonObject();
        try {
            this.fileInputStream = new FileInputStream(new File(excelDataFilePath));
            this.workbook = new XSSFWorkbook((InputStream)this.fileInputStream);
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        int numberOfSheets = this.workbook.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            String sheetName = this.workbook.getSheetName(i);
            Sheet sheet = this.workbook.getSheetAt(i);
            jsonObject.add(sheetName, (JsonElement)this.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(sheet, trimCellValues));
        }
        try {
            this.fileInputStream.close();
            this.workbook.close();
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        return jsonObject;
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(String excelDataFilePath, String excelSheetName) {
        return this.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(excelDataFilePath, excelSheetName, false);
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(String excelDataFilePath, String excelSheetName, boolean trimCellValues) {
        try {
            this.fileInputStream = new FileInputStream(new File(excelDataFilePath));
            this.workbook = new XSSFWorkbook((InputStream)this.fileInputStream);
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        Sheet sheet = this.workbook.getSheet(excelSheetName);
        JsonObject jsonObject = this.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(sheet, trimCellValues);
        try {
            this.fileInputStream.close();
            this.workbook.close();
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        return jsonObject;
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(Sheet sheet) {
        return this.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(sheet, false);
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(Sheet sheet, boolean trimCellValues) {
        Row row;
        JsonObject jsonObject = new JsonObject();
        JsonObject columnNames = new JsonObject();
        JsonArray columnValues = null;
        int maxColumnIndex = -1;
        StringOprs stringOprs = new StringOprs();
        Iterator iterator = sheet.iterator();
        block0: while (iterator.hasNext() && this.formatter.formatCellValue((row = (Row)iterator.next()).getCell(0)) != null) {
            String cellValue;
            if (row.getRowNum() == 0) {
                for (Cell cell : row) {
                    cellValue = this.formatter.formatCellValue(cell).trim();
                    columnNames.addProperty(Integer.toString(cell.getColumnIndex()), cellValue);
                    if (cellValue == "") continue block0;
                    columnNames.addProperty(Integer.toString(cell.getColumnIndex()), cellValue);
                    columnValues = new JsonArray();
                    if (jsonObject.get(cellValue) == null) {
                        jsonObject.add(cellValue, (JsonElement)columnValues);
                    } else {
                        new JavaException().throwException("El nombre de columna <" + cellValue + "> ubicado en la columna n\u00famero <" + (cell.getColumnIndex() + 1) + "> se encuentra repetido.", (Boolean)true);
                    }
                    ++maxColumnIndex;
                }
                continue;
            }
            if (row.getRowNum() < 1) continue;
            for (int i = 0; i <= maxColumnIndex; ++i) {
                Cell cell;
                cell = row.getCell(i);
                if (i > maxColumnIndex) continue block0;
                String columnName = columnNames.get(Integer.toString(i)).getAsString();
                cellValue = this.formatter.formatCellValue(cell);
                if (trimCellValues) {
                    cellValue = cellValue.trim();
                }
                if (!stringOprs.isEmptyOrNull(cellValue) && !this.existStringInStringsJsonArray(cellValue, jsonObject.get(columnName).getAsJsonArray())) {
                    jsonObject.get(columnName).getAsJsonArray().add(cellValue);
                    continue;
                }
                if (stringOprs.isEmptyOrNull(cellValue)) continue;
                System.out.println("El dato <" + cellValue + "> ubicado en la fila n\u00famero <" + (cell.getRowIndex() + 1) + "> se encuentra repetido en la columna <" + columnName + ">, se tendr\u00e1 en cuenta una sola ocurrencia.");
            }
        }
        return jsonObject;
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueFirstColumnValueKeyByRow(String excelDataFilePath, String excelSheetName) {
        return this.excelFileSheetToJsonObjecttWithUniqueFirstColumnValueKeyByRow(excelDataFilePath, excelSheetName, false);
    }

    public JsonObject excelFileSheetToJsonObjecttWithUniqueFirstColumnValueKeyByRow(String excelDataFilePath, String excelSheetName, boolean trimCellValues) {
        JsonObject jsonObject = new JsonObject();
        JsonObject columnNames = new JsonObject();
        JsonObject record = null;
        int maxColumnIndex = -1;
        try {
            this.fileInputStream = new FileInputStream(new File(excelDataFilePath));
            this.workbook = new XSSFWorkbook((InputStream)this.fileInputStream);
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        Sheet sheet = this.workbook.getSheet(excelSheetName);
        block4: for (Row row : sheet) {
            String cellValue;
            record = new JsonObject();
            String key = null;
            if (this.formatter.formatCellValue(row.getCell(0)) == "") break;
            if (row.getRowNum() == 0) {
                for (Cell cell : row) {
                    cellValue = this.formatter.formatCellValue(cell).trim();
                    columnNames.addProperty(Integer.toString(cell.getColumnIndex()), cellValue);
                    if (cellValue == "") continue block4;
                    columnNames.addProperty(Integer.toString(cell.getColumnIndex()), cellValue);
                    ++maxColumnIndex;
                }
                continue;
            }
            if (row.getRowNum() < 1) continue;
            for (int i = 0; i <= maxColumnIndex; ++i) {
                Cell cell;
                cell = row.getCell(i);
                if (i > maxColumnIndex) break;
                String columnName = columnNames.get(Integer.toString(i)).getAsString();
                cellValue = this.formatter.formatCellValue(cell);
                if (i == 0) {
                    key = cellValue;
                    continue;
                }
                if (trimCellValues) {
                    cellValue = cellValue.trim();
                }
                record.addProperty(columnName, cellValue);
            }
            jsonObject.add(key, (JsonElement)record);
        }
        try {
            this.fileInputStream.close();
            this.workbook.close();
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
        return jsonObject;
    }
}

