/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.os;

import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.JavaOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class WindowsOsOprs {
    private static final Logger LOGGER = LogManager.getLogger(WindowsOsOprs.class);

    public void killSystemProcessWhitTaskKillWindowsCommand(String systemProcessName) {
        this.executeWindowsCommand("taskkill /f /im " + systemProcessName);
    }

    public String killSystemProcessWhitTaskKillWindowsCommandAndWaitForItsDeath(String systemProcessName) {
        return this.executeWindowsCommandAndWaitForItsDeath("taskkill /f /im " + systemProcessName);
    }

    public void runBatchFile(String batchFilePath) {
        String command = "\"" + batchFilePath + "\"";
        this.executeWindowsCommandAndWaitForItsDeath(command);
    }

    public Process executeWindowsCommand(String command) {
        try {
            return Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String executeWindowsCommandAndWaitForItsDeath(String command) {
        String processInputStream = null;
        ProcessBuilder processBuilder = null;
        Process process = null;
        try {
            processBuilder = new ProcessBuilder("cmd.exe", "/c", command);
            process = processBuilder.start();
            process.waitFor();
            processInputStream = this.getProcessInputStream(process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return processInputStream;
    }

    private String getProcessInputStream(InputStream inputStream) {
        int bytesRead = -1;
        byte[] bytes = new byte[1024];
        String output = null;
        try {
            while ((bytesRead = inputStream.read(bytes)) > -1) {
                output = output + new String(bytes, 0, bytesRead);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output;
    }

    public String getCurrentUserName() {
        return System.getProperty("user.name");
    }

    public String getCurrentHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessRunning(String processName) {
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("WMIC");
        command.add("process");
        command.add("list");
        command.add("brief");
        try {
            String line;
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            processName = processName.toUpperCase();
            while ((line = br.readLine()) != null) {
                if (line.toUpperCase().indexOf(processName) <= -1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void printAllOpenSystemProcesses() {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                LOGGER.info((Object)line);
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitUntilSystemProcessStarts(String processName, int seconds) {
        try {
            for (int contador = 0; !this.isProcessRunning(processName) && contador <= seconds; ++contador) {
                new JavaOprs().sleepInSeconds(1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitUntilSystemProcessIsFinished(String processName, int seconds) {
        try {
            for (int contador = 0; this.isProcessRunning(processName) && contador <= seconds; ++contador) {
                new JavaOprs().sleepInSeconds(1L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void releaseSystemPort(String systemPort) {
        StringOprs stringOprs = new StringOprs();
        String commandResponse = this.executeWindowsCommandAndWaitForItsDeath("netstat -ano | findstr :" + systemPort);
        String processId = null;
        if (commandResponse != null) {
            processId = stringOprs.getStringWithRegex("[0-9]+", stringOprs.getStringWithRegex("LISTENING.*[0-9]+", commandResponse, false), false);
        }
        if (processId != null) {
            this.executeWindowsCommandAndWaitForItsDeath("taskkill /pid " + processId + " /f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findAndGetFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            int systemPort = socket.getLocalPort();
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.releaseSystemPort(String.valueOf(systemPort));
            String string = String.valueOf(systemPort);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IllegalStateException("Could not find a free TCP/IP System Port");
    }

    public void openTextFileInWindowsNotepad(String filePath) {
        if (new FileOprs().existsFile(filePath)) {
            this.executeWindowsCommand("cmd.exe /s /c start /max notepad \"" + filePath + "\"");
        }
    }

    public void openWindowsExplorerAndSelectFile(String filePath) {
        if (new FileOprs().existsFile(filePath)) {
            this.executeWindowsCommand("explorer.exe /select," + filePath);
        }
    }
}

