/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.jms;

import com.qa.automation.utils.java.utils.exception.JavaException;
import java.util.Hashtable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AsyncReceiver
implements MessageListener,
ExceptionListener {
    private static String textMsg = "";

    public AsyncReceiver() {
    }

    public AsyncReceiver(String initialContextFactory, String providerURL, String queueConnectionFactory, String queueResponse) {
        try {
            this.setup(initialContextFactory, providerURL, queueConnectionFactory, queueResponse);
        }
        catch (InterruptedException | JMSException | NamingException e) {
            new JavaException().catchException(e);
        }
    }

    public void setup(String initialContextFactory, String providerURL, String queueConnectionFactory, String queueResponse) throws NamingException, JMSException, InterruptedException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactory);
        env.put("java.naming.provider.url", providerURL);
        InitialContext ctx = new InitialContext(env);
        Queue queue = (Queue)ctx.lookup(queueResponse);
        QueueConnectionFactory connFactory = (QueueConnectionFactory)ctx.lookup(queueConnectionFactory);
        QueueConnection queueConn = connFactory.createQueueConnection();
        QueueSession queueSession = queueConn.createQueueSession(false, 1);
        QueueReceiver queueReceiver = queueSession.createReceiver(queue);
        AsyncReceiver receiver = new AsyncReceiver();
        queueReceiver.setMessageListener((MessageListener)receiver);
        queueConn.setExceptionListener((ExceptionListener)receiver);
        queueConn.start();
        System.out.print("Esperando por mensajes");
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(1000L);
            System.out.print(".");
        }
        queueConn.close();
    }

    public String getMessage() {
        return textMsg;
    }

    public void onException(JMSException exception) {
        System.err.println("Un error ha ocurrido: " + (Object)((Object)exception));
    }

    public void onMessage(Message message) {
        TextMessage msg = (TextMessage)message;
        try {
            System.out.println(msg.getText());
        }
        catch (JMSException e) {
            new JavaException().catchException(e);
        }
    }
}

