/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.params;

import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.exception.JavaException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class ProjectConfigProperties {
    private static final String PROJECT_CONFIG_PROPERTIES_FILE_DEFAULT_NAME = "project.config.properties";
    private static Properties properties = null;
    private static StringOprs stringOprs = new StringOprs();

    public static void addConfigPropertiesFile(String configPropertiesFilePath) {
        try {
            FileInputStream inputStream = new FileInputStream(configPropertiesFilePath);
            ProjectConfigProperties.addConfigPropertiesFile(inputStream);
        }
        catch (Exception e) {
            new JavaException().throwException("No fue posible cargar el archivo de propiedades de configuraci\u00f3n del proyecto", e, true);
        }
    }

    public static void addConfigPropertiesFile(InputStream inputStream) {
        if (properties == null) {
            properties = new Properties();
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            ProjectConfigProperties.properties.putAll((Map<?, ?>)properties);
        }
        catch (Exception e) {
            new JavaException().throwException("No fue posible cargar el archivo de propiedades de configuraci\u00f3n del proyecto", e, true);
        }
    }

    public static void setProperty(String key, String value) {
        if (!stringOprs.isEmptyOrNull(key)) {
            key = key.trim();
        }
        if (!stringOprs.isEmptyOrNull(value)) {
            value = value.trim();
        }
        if (properties != null) {
            properties.setProperty(key, value);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    public static String getAsString(String key) {
        String value;
        if (!stringOprs.isEmptyOrNull(key)) {
            key = key.trim();
        }
        String string = value = properties == null ? null : properties.getProperty(key, "");
        if (stringOprs.isEmptyOrNull(value)) {
            new JavaException().throwException("El par\u00e1metro de configuraci\u00f3n del proyecto <" + key + "> no existe");
        }
        return value == null ? null : value.trim();
    }

    public static Boolean getAsBoolean(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Boolean.parseBoolean(value);
    }

    public static int getAsInteger(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Integer.parseInt(value);
    }

    public static double getAsDouble(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Double.parseDouble(value);
    }

    public static long getAsLong(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Long.parseLong(value);
    }

    public static float getAsFloat(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Float.parseFloat(value);
    }

    public static byte getAsByte(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Byte.parseByte(value);
    }

    public static short getAsShort(String key) {
        String value = ProjectConfigProperties.getAsString(key);
        return Short.parseShort(value);
    }

    static {
        InputStream inputStream = ProjectConfigProperties.class.getResourceAsStream("/project.config.properties");
        ProjectConfigProperties.addConfigPropertiesFile(inputStream);
    }
}

