/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.dataset;

import com.google.gson.JsonObject;
import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.JavaOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.exception.JavaException;
import com.qa.automation.utils.java.utils.json.JsonOprs;

public class Dataset {
    private String excelDataFilePath;
    private FileOprs fileOprs = new FileOprs();
    private StringOprs stringOprs = new StringOprs();
    private JavaOprs javaOprs = new JavaOprs();
    private JsonOprs jsonOprs = new JsonOprs();
    private JsonObject dataset;

    public Dataset(String excelDataFilePath) {
        this.setDataset(excelDataFilePath, "Dataset", false);
    }

    public Dataset(String excelDataFilePath, boolean trimCellValues) {
        this.setDataset(excelDataFilePath, "Dataset", trimCellValues);
    }

    public Dataset(String excelDataFilePath, String excelSheetName) {
        this.setDataset(excelDataFilePath, excelSheetName, false);
    }

    public Dataset(String excelDataFilePath, String excelSheetName, boolean trimCellValues) {
        this.setDataset(excelDataFilePath, excelSheetName, trimCellValues);
    }

    private void setDataset(String excelDataFilePath, String excelSheetName, Boolean trimCellValues) {
        this.tryFindExcelFile(excelDataFilePath);
        this.dataset = this.jsonOprs.excelFileSheetToJsonObjecttWithUniqueColumnNameKeyByColumn(this.excelDataFilePath, excelSheetName, trimCellValues);
    }

    private void tryFindExcelFile(String excelDataFilePath) {
        this.excelDataFilePath = this.stringOprs.isEmptyOrNull(this.fileOprs.checkIfExistsFileAndGetAbsolutePath(excelDataFilePath)) ? this.fileOprs.findFileAndGetAbsoluteFilePath(this.javaOprs.getThisProjectDirectoryPath(), excelDataFilePath) : excelDataFilePath;
        if (this.stringOprs.isEmptyOrNull(this.excelDataFilePath)) {
            new JavaException().throwException("El archivo excel <" + excelDataFilePath + "> con los datos de prueba no existe");
        }
    }

    public JsonObject getDataRow(String id) {
        return this.dataset.getAsJsonObject(id);
    }

    public String getDataValue(String path) {
        String[] dataRecordArray = path.split("\\.");
        return this.dataset.getAsJsonObject(dataRecordArray[0]).get(dataRecordArray[1]).getAsString();
    }

    public String getDataValue(String id, String columnName) {
        return this.dataset.getAsJsonObject(id).get(columnName).getAsString();
    }

    public void printData() {
        this.jsonOprs.printJsonObject(this.dataset);
    }

    public JsonObject getData() {
        return this.dataset;
    }

    public String getExcelDataFilePath() {
        return this.excelDataFilePath;
    }
}

