/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.common;

import java.net.URL;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringOprs {
    public List<String> getStringListWithRegex(String regex, String text, boolean repeatString) {
        return this.getStringListWithRegex(regex, text, repeatString, true);
    }

    public List<String> getStringListWithRegex(String regex, String text, boolean repeatString, boolean caseSensitive) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = caseSensitive ? Pattern.compile(regex).matcher(text) : Pattern.compile(regex, 2).matcher(text);
        while (matcher.find()) {
            if (repeatString) {
                matches.add(matcher.group());
                continue;
            }
            if (matches.contains(matcher.group())) continue;
            matches.add(matcher.group());
        }
        return matches;
    }

    public boolean evaluateRegex(String regex, String text, boolean caseSensitive) {
        String regexResult = this.getStringWithRegex(regex, text, caseSensitive);
        return !this.isEmptyOrNull(regexResult);
    }

    public boolean evaluateRegex(String regex, String text) {
        return this.evaluateRegex(regex, text, true);
    }

    public String getStringWithRegex(String regex, String text, boolean caseSensitive) {
        Matcher matcher = caseSensitive ? Pattern.compile(regex).matcher(text) : Pattern.compile(regex, 2).matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    public String getStringWithRegex(String regex, String text) {
        return this.getStringWithRegex(regex, text, true);
    }

    public String cutString(String string, int maxStringLength) {
        if (string.length() > maxStringLength) {
            string = string.substring(0, maxStringLength);
        }
        return string;
    }

    public boolean isNull(String string) {
        return string == null || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("nulo");
    }

    public boolean isEmptyOrNull(String string) {
        return string == null || string.isEmpty();
    }

    public String firstCharToLowerCase(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1, string.length());
    }

    public String firstCharToUpperCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1, string.length()).toLowerCase();
    }

    public String removeAllSpaces(String string) {
        return string.replaceAll("\\s*", "");
    }

    public String[] splitWithoutWhitespaces(String stringToSplit, String stringUsedToSplit) {
        String[] arraySplit = new String[]{};
        if (!this.isEmptyOrNull(stringToSplit)) {
            arraySplit = stringToSplit.replaceAll("\\s*" + stringUsedToSplit + "\\s*", stringUsedToSplit).split(stringUsedToSplit);
        }
        return arraySplit;
    }

    public int getCountOccurrences(String string, String substring) {
        int indexOf;
        int cant = 0;
        while ((indexOf = string.indexOf(substring)) > -1) {
            string = string.substring(indexOf + substring.length(), string.length());
            ++cant;
        }
        return cant;
    }

    public String getStringBetweenTwoStrings(String string, String leftString, String rigthString) {
        int beginIndex = string.lastIndexOf(leftString) + leftString.length();
        int endIndex = string.indexOf(rigthString);
        return string.substring(beginIndex, endIndex);
    }

    public String reverseSplit(String[] array, String stringUsedToSplit) {
        String stringToSplit = "";
        int arrayLength = array.length;
        boolean flagCharSplit = false;
        if (arrayLength > 0) {
            for (int i = 0; i < arrayLength; ++i) {
                if (!flagCharSplit) {
                    stringToSplit = array[i];
                    flagCharSplit = true;
                    continue;
                }
                stringToSplit = stringToSplit + stringUsedToSplit + array[i];
            }
        }
        return stringToSplit;
    }

    public String wrapText(String original_text, int chars_per_line) {
        String retval = "";
        int char_counter = 0;
        boolean insert_rc = false;
        if (original_text != null) {
            int len = original_text.length();
            for (int i = 0; i < len; ++i) {
                retval = retval + original_text.charAt(i);
                ++char_counter;
                if (insert_rc && original_text.charAt(i) == ' ') {
                    retval = retval + "\n";
                    insert_rc = false;
                }
                if (char_counter <= chars_per_line) continue;
                char_counter = 0;
                insert_rc = true;
            }
        }
        return retval;
    }

    public Boolean isNumeric(String string) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(string, pos);
        return string.length() == pos.getIndex();
    }

    public String getStringUntilFirstWhitespace(String string) {
        int endIndex = this.findFirstWhitespace(string);
        if (endIndex == -1) {
            return string;
        }
        return string.substring(0, endIndex);
    }

    public int findFirstWhitespace(String string) {
        for (int index = 0; index < string.length(); ++index) {
            if (!Character.isWhitespace(string.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public boolean isUrlValid(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long stringToLong(String str) {
        return Long.parseLong(str);
    }

    public int stringToInteger(String str) {
        return Integer.parseInt(str);
    }

    public String leftPad(String str, int size, String padChar) {
        return StringUtils.leftPad((String)str, (int)size, (String)padChar);
    }

    public String leftPad(int number, int size, String padChar) {
        return this.leftPad(String.valueOf(number), size, padChar);
    }

    public String rightPad(String str, int size, String padChar) {
        return StringUtils.rightPad((String)str, (int)size, (String)padChar);
    }

    public String rightPad(int number, int size, String padChar) {
        return this.rightPad(String.valueOf(number), size, padChar);
    }
}

