/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.jms;

import com.qa.automation.utils.java.utils.exception.JavaException;
import com.qa.automation.utils.java.utils.jms.AsyncReceiver;
import com.qa.automation.utils.java.utils.jms.Search;
import com.qa.automation.utils.java.utils.jms.Sender;
import com.qa.automation.utils.java.utils.jms.SyncReceiver;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class PointToPoint {
    private String initialContextFactory;
    private String providerURL;
    private String queueConnectionFactory;
    private String queueRequest;
    private String queueResponse;
    private String messageRequest;

    public PointToPoint(String initialContextFactory, String providerURL, String queueConnectionFactory, String queueRequest, String queueResponse, String messageRequest) {
        this.setup(initialContextFactory, providerURL, queueConnectionFactory, queueRequest, queueResponse, messageRequest);
    }

    public void setup(String initialContextFactory, String providerURL, String queueConnectionFactory, String queueRequest, String queueResponse, String messageRequest) {
        this.initialContextFactory = initialContextFactory;
        this.providerURL = providerURL;
        this.queueConnectionFactory = queueConnectionFactory;
        this.queueRequest = queueRequest;
        this.queueResponse = queueResponse;
        this.messageRequest = messageRequest;
    }

    public void BrowseRequestQueue() {
        try {
            new Search(this.initialContextFactory, this.providerURL, this.queueConnectionFactory, this.queueRequest);
        }
        catch (JMSException | NamingException e) {
            new JavaException().catchException(e);
        }
    }

    public void BrowseResponseQueue() {
        try {
            new Search(this.initialContextFactory, this.providerURL, this.queueConnectionFactory, this.queueResponse);
        }
        catch (JMSException | NamingException e) {
            new JavaException().catchException(e);
        }
    }

    public void ReceiveAsyncMessage() {
        new AsyncReceiver(this.initialContextFactory, this.providerURL, this.queueConnectionFactory, this.queueResponse);
    }

    public void ReceiveSyncMessage() {
        try {
            new SyncReceiver(this.initialContextFactory, this.providerURL, this.queueConnectionFactory, this.queueResponse);
        }
        catch (InterruptedException | JMSException | NamingException e) {
            new JavaException().catchException(e);
        }
    }

    public String SendMessage() {
        try {
            Sender sender = new Sender(this.initialContextFactory, this.providerURL, this.queueConnectionFactory, this.queueRequest, this.messageRequest);
            return sender.getMsgID();
        }
        catch (JMSException | NamingException e) {
            new JavaException().catchException(e);
            return "";
        }
    }
}

