/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.common;

import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.params.JavaUtilsParams;
import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileOprs
extends FileUtils {
    public String addBackslashToEndOfDirectoryPath(String directoryPath) {
        StringOprs stringOprs = new StringOprs();
        if (!stringOprs.isEmptyOrNull(directoryPath) && !directoryPath.endsWith(JavaUtilsParams.PATH_SEPARATOR_CHAR)) {
            directoryPath = directoryPath + JavaUtilsParams.PATH_SEPARATOR_CHAR;
        }
        return directoryPath;
    }

    public String removeBackslashToEndOfDirectoryPath(String directoryPath) {
        StringOprs stringOprs = new StringOprs();
        if (!stringOprs.isEmptyOrNull(directoryPath) && directoryPath.endsWith(JavaUtilsParams.PATH_SEPARATOR_CHAR)) {
            directoryPath = directoryPath.substring(0, directoryPath.lastIndexOf(JavaUtilsParams.PATH_SEPARATOR_CHAR));
        }
        return directoryPath;
    }

    public String findFileBackwardsAndGetAbsoluteFilePath(String pivotDirectoryPath, String fileName) {
        StringOprs stringOprs = new StringOprs();
        String absoluteFilePath = null;
        if (!stringOprs.isEmptyOrNull(pivotDirectoryPath) && !stringOprs.isEmptyOrNull(fileName)) {
            while (!stringOprs.isEmptyOrNull(pivotDirectoryPath)) {
                if (this.existsFile(this.normalizePath(pivotDirectoryPath, fileName))) {
                    if (this.isDirectory(fileName)) {
                        absoluteFilePath = this.addBackslashToEndOfDirectoryPath(this.normalizePath(pivotDirectoryPath, fileName));
                        break;
                    }
                    absoluteFilePath = this.normalizePath(pivotDirectoryPath, fileName);
                    break;
                }
                pivotDirectoryPath = this.getParentDirectoryPathFromFilePath(pivotDirectoryPath);
            }
        }
        return absoluteFilePath;
    }

    public String findFileInThisProjectAndGetAbsoluteFilePath(String fileNameWithExtension) {
        return this.findFileAndGetAbsoluteFilePath(System.getProperty("user.dir"), fileNameWithExtension);
    }

    public String findFileAndGetAbsoluteFilePath(String searchDirectoryPath, String fileNameWithExtension) {
        StringOprs stringOprs = new StringOprs();
        String subdirectory = this.getDirectoryPathFromFilePath(fileNameWithExtension);
        fileNameWithExtension = this.getFileNameWithExtensionFromFilePath(fileNameWithExtension);
        String absoluteFilePath = null;
        if (searchDirectoryPath != null) {
            File sourceDirectoryFile = new File(searchDirectoryPath);
            Collection files = FileUtils.listFiles((File)sourceDirectoryFile, null, (boolean)true);
            for (File file : files) {
                if (!file.getName().equals(fileNameWithExtension)) continue;
                absoluteFilePath = file.getAbsolutePath();
                if (stringOprs.isEmptyOrNull(subdirectory) || absoluteFilePath.contains(this.normalizePath(subdirectory, fileNameWithExtension))) break;
                absoluteFilePath = null;
            }
        }
        return absoluteFilePath;
    }

    public String findDirectoryAndGetAbsoluteDirectoryPath(String searchDirectoryPath, String directoryName) {
        StringOprs stringOprs = new StringOprs();
        String subdirectory = this.getDirectoryPathFromFilePath(directoryName);
        directoryName = this.getFileNameWithExtensionFromFilePath(directoryName);
        String absoluteDirectoryPath = null;
        if (searchDirectoryPath != null) {
            File sourceDirectoryFile = new File(searchDirectoryPath);
            Collection files = FileUtils.listFilesAndDirs((File)sourceDirectoryFile, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
            for (File file : files) {
                if (!file.getName().equals(directoryName)) continue;
                absoluteDirectoryPath = file.getAbsolutePath();
                if (stringOprs.isEmptyOrNull(subdirectory) || absoluteDirectoryPath.contains(this.removeBackslashToEndOfDirectoryPath(this.normalizePath(subdirectory, directoryName)))) break;
                absoluteDirectoryPath = null;
            }
        }
        return absoluteDirectoryPath;
    }

    public String getFileContent(String filePath) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFileContent(String filePath, Charset encoding) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (Charset)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getFileContent(String filePath, String encoding) {
        File file = new File(filePath);
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement, String encoding) {
        return this.getFileContent(filePath, encoding).replaceAll(regex, replacement);
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement, Charset encoding) {
        return this.getFileContent(filePath, encoding).replaceAll(regex, replacement);
    }

    public String replaceStringInFileContent(String filePath, String regex, String replacement) {
        return this.getFileContent(filePath).replaceAll(regex, replacement);
    }

    public void writeFileContent(String filePath, String content) {
        this.writeFileContent(filePath, content, false);
    }

    public void writeFileContent(String filePath, String content, boolean append) {
        File file = new File(filePath);
        this.createParentDirectory(filePath);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, append));){
            bufferedWriter.write(content);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String normalizePath(String leftPath, String rightPath) {
        Path path = Paths.get(leftPath + JavaUtilsParams.PATH_SEPARATOR_CHAR + rightPath, new String[0]);
        String filePath = path.normalize().toString();
        if (this.existsFile(filePath)) {
            if (this.isDirectory(filePath)) {
                filePath = this.addBackslashToEndOfDirectoryPath(filePath);
            }
        } else if (this.checkIfPathStringIsDirectoryPath(filePath)) {
            filePath = this.addBackslashToEndOfDirectoryPath(filePath);
        }
        return filePath;
    }

    public boolean compareFiles(String filePathOne, String filePathTwo) {
        try {
            File file01 = new File(filePathOne);
            File file02 = new File(filePathTwo);
            return FileUtils.contentEquals((File)file01, (File)file02);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean existsFile(String filePath) {
        boolean response = false;
        try {
            File file = new File(filePath);
            if (file.exists()) {
                response = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    public String checkIfExistsFileAndGetAbsolutePath(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void createParentDirectory(String filePath) {
        File file = new File(filePath);
        this.createDirectory(file.getParent());
    }

    public void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isFile()) {
            try {
                Files.delete(Paths.get(filePath, new String[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isDirectory(String directoryPath) {
        File file = new File(directoryPath);
        return file.isDirectory();
    }

    public boolean isDirectoryEmpty(String directoryPath) {
        File file = new File(directoryPath);
        return file.list().length == 0;
    }

    public boolean checkIfPathStringIsDirectoryPath(String directoryPathString) {
        return !this.checkIfPathStringIsFilePath(directoryPathString);
    }

    public boolean isFile(String filePath) {
        File file = new File(filePath);
        return file.isFile();
    }

    public boolean checkIfPathStringIsFilePath(String filePathString) {
        String regex = "(.+)(:" + JavaUtilsParams.PATH_SEPARATOR_CHAR + JavaUtilsParams.PATH_SEPARATOR_CHAR + ")?(.+)(\\.)([^" + JavaUtilsParams.PATH_SEPARATOR_CHAR + JavaUtilsParams.PATH_SEPARATOR_CHAR + "]+)";
        return new StringOprs().evaluateRegex(regex, filePathString, false);
    }

    public void deleteDirectory(String directoryPath) {
        try {
            File file = new File(directoryPath);
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyDirectory(String sourceDirectoryPath, String targetDirectoryPath) {
        try {
            File sourceFile = new File(sourceDirectoryPath);
            File targetFile = new File(targetDirectoryPath);
            FileUtils.copyDirectory((File)sourceFile, (File)targetFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cutDirectory(String sourceDirectoryPath, String targetDirectoryPath) {
        this.copyDirectory(sourceDirectoryPath, targetDirectoryPath);
        this.deleteDirectory(sourceDirectoryPath);
    }

    public void copyAllDirectoryFilesToDirectory(String sourceFilePath, String targetDirectoryPath) {
        try {
            File[] sourceFileList;
            File sourceFile = new File(sourceFilePath);
            File targetFile = new File(targetDirectoryPath);
            if (sourceFile.isFile()) {
                FileUtils.copyFileToDirectory((File)sourceFile, (File)targetFile);
                return;
            }
            for (File srcFile : sourceFileList = sourceFile.listFiles()) {
                if (srcFile.isFile()) {
                    FileUtils.copyFileToDirectory((File)srcFile, (File)targetFile);
                    continue;
                }
                FileUtils.copyDirectory((File)srcFile, (File)new File(this.normalizePath(targetDirectoryPath, srcFile.getName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyFile(String sourceFilePath, String targetFilePath) {
        try {
            if (new File(targetFilePath).isDirectory()) {
                String fileName = this.getFileNameWithExtensionFromFilePath(sourceFilePath);
                targetFilePath = this.normalizePath(targetFilePath, fileName);
            }
            File sourceFile = new File(sourceFilePath);
            File targetFile = new File(targetFilePath);
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyFileFromURL(String sourceFilePath, String targetFilePath) {
        try {
            new URL(sourceFilePath);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            FileUtils.copyURLToFile((URL)new URL(sourceFilePath), (File)new File(targetFilePath));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cutFile(String sourceFilePath, String targetFilePath) {
        this.copyFile(sourceFilePath, targetFilePath);
        this.deleteFile(sourceFilePath);
    }

    public String getFileNameWithoutExtensionFromFilePath(String filePath) {
        if (filePath.endsWith(JavaUtilsParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return FilenameUtils.getBaseName((String)filePath);
    }

    public String getFileNameWithExtensionFromFilePath(String filePath) {
        if (filePath.endsWith(JavaUtilsParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        return FilenameUtils.getName((String)filePath);
    }

    public String getFileExtensionFromFilePath(String filePath) {
        return FilenameUtils.getExtension((String)filePath);
    }

    public String getDirectoryPathFromFilePath(String filePath) {
        if ((filePath = this.removeBackslashToEndOfDirectoryPath(filePath)).startsWith(JavaUtilsParams.PATH_SEPARATOR_CHAR)) {
            filePath = filePath.substring(1, filePath.length());
        }
        return filePath.substring(0, filePath.lastIndexOf(JavaUtilsParams.PATH_SEPARATOR_CHAR) + 1);
    }

    public String getParentDirectoryPathFromFilePath(String filePath) {
        Path directoryPath = Paths.get(filePath, new String[0]).getParent();
        if (directoryPath != null) {
            return directoryPath.toString();
        }
        return null;
    }

    public String findFileAndGetFilePath(String fileNameWildcardToFind, String searchDirectoryPath) {
        File directory = new File(searchDirectoryPath);
        WildcardFileFilter fileFilter = new WildcardFileFilter(fileNameWildcardToFind);
        File[] files = directory.listFiles((FileFilter)fileFilter);
        if (files.length != 0) {
            return files[0].getAbsolutePath();
        }
        return null;
    }

    public int countFilesInDirectory(String directoryPath) {
        return this.countFilesInDirectory(directoryPath, false);
    }

    public int countFilesInDirectory(String directoryPath, boolean isRecursive) {
        File f = new File(directoryPath);
        int cuenta = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                ++cuenta;
                File file = files[i];
                if (!file.isDirectory() || !isRecursive) continue;
                this.countFilesInDirectory(file.getAbsolutePath(), isRecursive);
            }
        }
        return cuenta;
    }

    public void openFile(String filePath) {
        if (this.existsFile(filePath)) {
            try {
                Desktop.getDesktop().open(new File(filePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

