/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.excel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qa.automation.utils.java.utils.common.StringOprs;
import com.qa.automation.utils.java.utils.exception.JavaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExtendedColor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.Assert;

public class ExcelOprs {
    private static final Logger LOGGER = LogManager.getLogger(ExcelOprs.class);
    private static final String CELL_VALUE = "cellValue";
    private static final String CELL_FILL_COLOR = "cellFillColor";
    private String filePath = null;
    private Workbook workbook = null;
    private JsonObject workbookJsonObject = null;
    private FileInputStream fileInputStream = null;
    private FileOutputStream fileOutputStream = null;
    private DataFormatter formatter = new DataFormatter();

    private void resetAttributes() {
        this.filePath = null;
        this.workbook = null;
        this.workbookJsonObject = null;
        this.fileInputStream = null;
        this.fileOutputStream = null;
    }

    public Workbook createWorkbook(String filePath) {
        this.filePath = filePath;
        this.workbook = new XSSFWorkbook();
        return this.workbook;
    }

    public Workbook loadWorkbook(String filePath) {
        this.filePath = filePath;
        try {
            this.fileInputStream = new FileInputStream(new File(filePath));
            this.workbook = new XSSFWorkbook((InputStream)this.fileInputStream);
            return this.workbook;
        }
        catch (Exception e) {
            new JavaException().catchException(e);
            return null;
        }
    }

    public Sheet createSheet(String sheetName) {
        return this.workbook.createSheet(sheetName);
    }

    public void saveWorkbook() {
        try {
            this.fileOutputStream = new FileOutputStream(this.filePath);
            this.workbook.write((OutputStream)this.fileOutputStream);
            this.closeWorkbook();
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
    }

    public void closeWorkbook() {
        try {
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
            }
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (this.workbook != null) {
                this.workbook.close();
            }
            this.resetAttributes();
        }
        catch (Exception e) {
            new JavaException().catchException(e);
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public JsonObject getWorkbookJsonObject() {
        return this.workbookJsonObject;
    }

    public JsonArray getSheetJsonArray(String sheetName) {
        return this.workbookJsonObject.get(sheetName).getAsJsonArray();
    }

    public Sheet getSheet(String sheetName) {
        return this.workbook.getSheet(sheetName);
    }

    public JsonArray getRowJsonArray(String sheetName, int rowNum) {
        return this.workbookJsonObject.get(sheetName).getAsJsonArray().get(rowNum).getAsJsonArray();
    }

    public Row getRow(String sheetName, int rowNum) {
        return this.workbook.getSheet(sheetName).getRow(rowNum);
    }

    public JsonObject getCellJsonObject(String sheetName, int rowNum, int cellNum) {
        return this.workbookJsonObject.get(sheetName).getAsJsonArray().get(rowNum).getAsJsonArray().get(cellNum).getAsJsonObject();
    }

    public String getCellPropertyJsonObject(String sheetName, int rowNum, int cellNum, String property) {
        return this.workbookJsonObject.get(sheetName).getAsJsonArray().get(rowNum).getAsJsonArray().get(cellNum).getAsJsonObject().get(property).getAsString();
    }

    public Cell getCell(String sheetName, int rowNum, int cellNum) {
        return this.workbook.getSheet(sheetName).getRow(rowNum).getCell(cellNum, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    public String getCellValueJsonElement(String sheetName, int rowNum, int cellNum) {
        return this.getCellPropertyJsonObject(sheetName, rowNum, cellNum, CELL_VALUE);
    }

    public String getCellValue(String sheetName, int rowNum, int cellNum) {
        return this.formatter.formatCellValue(this.getCell(sheetName, rowNum, cellNum));
    }

    public String getCellValue(String sheetName, int rowNum, int cellNum, FormulaEvaluator evaluator) {
        return this.formatter.formatCellValue(this.getCell(sheetName, rowNum, cellNum), evaluator);
    }

    public String getCellFillColorCodeJsonElement(String sheetName, int rowNum, int cellNum) {
        return this.getCellPropertyJsonObject(sheetName, rowNum, cellNum, CELL_FILL_COLOR);
    }

    public String getCellFillColorCode(String sheetName, int rowNum, int cellNum) {
        return this.getCellFillColorCode(this.getCell(sheetName, rowNum, cellNum));
    }

    public void setSheetWithCachedRowSet(CachedRowSet cachedRowSet, String sheetName) {
        this.setSheetWithCachedRowSet(cachedRowSet, sheetName, false, false);
    }

    public void setSheetWithCachedRowSet(CachedRowSet cachedRowSet, String sheetName, boolean autoFilter, boolean lockFirstRow) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.createSheet(sheetName);
        }
        Font font = this.workbook.createFont();
        font.setFontHeightInPoints((short)8);
        font.setFontName("Calibri");
        Font fontBold = this.workbook.createFont();
        fontBold.setFontHeightInPoints((short)8);
        fontBold.setFontName("Calibri");
        fontBold.setBold(true);
        CellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setFont(fontBold);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        CellStyle dataStyle = this.workbook.createCellStyle();
        dataStyle.setFont(font);
        dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        sheet.setDefaultRowHeight((short)230);
        sheet.setDefaultColumnWidth(20);
        try {
            Cell cell;
            int numberColumns = 0;
            ResultSetMetaData resultSetMetaData = cachedRowSet.getMetaData();
            numberColumns = resultSetMetaData.getColumnCount();
            Row row = sheet.createRow(0);
            for (int i = 0; i < numberColumns; ++i) {
                cell = row.createCell(i);
                cell.setCellValue(resultSetMetaData.getColumnName(i + 1));
                cell.setCellStyle(headerStyle);
            }
            int rowIndex = 1;
            cachedRowSet.beforeFirst();
            while (cachedRowSet.next()) {
                row = sheet.createRow(rowIndex);
                for (int i = 0; i < numberColumns; ++i) {
                    cell = row.createCell(i);
                    cell.setCellValue(cachedRowSet.getString(i + 1));
                    cell.setCellStyle(dataStyle);
                }
                ++rowIndex;
            }
            if (lockFirstRow && rowIndex > 1) {
                sheet.createFreezePane(0, 1);
            }
            if (autoFilter && rowIndex > 1) {
                sheet.setAutoFilter(new CellRangeAddress(0, 0, 0, numberColumns - 1));
            }
        }
        catch (SQLException e) {
            this.closeWorkbook();
            new JavaException().catchException(e);
        }
    }

    public boolean compareExcelFiles(String expectedFilePath, String actualFilePath) {
        int j;
        JsonArray sheet02;
        JsonArray sheet01;
        int i;
        String sheetName02;
        String sheetName01;
        StringOprs stringOprs = new StringOprs();
        LOGGER.log((Priority)Level.INFO, (Object)("Comparando contenido de archivos excel: expectedFilePath: " + expectedFilePath + " | actualFilePath: " + actualFilePath));
        JsonObject workbookJsonObject01 = this.loadWorkbookToJsonObject(expectedFilePath);
        JsonObject workbookJsonObject02 = this.loadWorkbookToJsonObject(actualFilePath);
        Object[] sheets01 = workbookJsonObject01.keySet().toArray();
        Object[] sheets02 = workbookJsonObject02.keySet().toArray();
        boolean sheetNumberValidation = true;
        boolean sheetNamesValidation = true;
        boolean rowNumberValidation = true;
        boolean columnNumberValidation = true;
        boolean cellValueValidation = true;
        boolean comparationStatus = true;
        int numberOfSheets01 = sheets01.length;
        int numberOfSheets02 = sheets02.length;
        boolean bl = sheetNumberValidation = numberOfSheets01 == numberOfSheets02;
        if (!sheetNumberValidation) {
            comparationStatus = false;
            sheetNamesValidation = false;
            rowNumberValidation = false;
            columnNumberValidation = false;
            cellValueValidation = false;
        }
        if (comparationStatus) {
            for (int i2 = 0; i2 < sheets01.length; ++i2) {
                sheetName01 = (String)sheets01[i2];
                sheetName02 = (String)sheets02[i2];
                if (!sheetNamesValidation || sheetName01.equalsIgnoreCase(sheetName02)) continue;
                comparationStatus = false;
                sheetNamesValidation = false;
                rowNumberValidation = false;
                columnNumberValidation = false;
                cellValueValidation = false;
            }
        }
        if (comparationStatus) {
            for (int i3 = 0; i3 < sheets01.length; ++i3) {
                sheetName01 = (String)sheets01[i3];
                sheetName02 = (String)sheets02[i3];
                int numberOfRows01 = workbookJsonObject01.get(sheetName01).getAsJsonArray().size();
                int numberOfRows02 = workbookJsonObject02.get(sheetName02).getAsJsonArray().size();
                if (!rowNumberValidation || numberOfRows01 == numberOfRows02) continue;
                comparationStatus = false;
                rowNumberValidation = false;
                columnNumberValidation = false;
                cellValueValidation = false;
            }
        }
        if (comparationStatus) {
            for (i = 0; i < sheets01.length; ++i) {
                sheetName01 = (String)sheets01[i];
                sheetName02 = (String)sheets02[i];
                sheet01 = workbookJsonObject01.get(sheetName01).getAsJsonArray();
                sheet02 = workbookJsonObject02.get(sheetName02).getAsJsonArray();
                int numberOfColumns01 = 0;
                int numberOfColumns02 = 0;
                for (j = 0; j < sheet01.size(); ++j) {
                    int numberOfRowColumns01 = sheet01.get(j).getAsJsonArray().size();
                    int numberOfRowColumns02 = sheet02.get(j).getAsJsonArray().size();
                    if (numberOfRowColumns01 > numberOfColumns01) {
                        numberOfColumns01 = numberOfRowColumns01;
                    }
                    if (numberOfRowColumns02 > numberOfColumns02) {
                        numberOfColumns02 = numberOfRowColumns02;
                    }
                    if (!columnNumberValidation || numberOfColumns01 == numberOfColumns02) continue;
                    comparationStatus = false;
                    columnNumberValidation = false;
                    cellValueValidation = false;
                }
            }
        }
        if (comparationStatus) {
            for (i = 0; i < sheets01.length; ++i) {
                sheetName01 = (String)sheets01[i];
                sheetName02 = (String)sheets02[i];
                sheet01 = workbookJsonObject01.get(sheetName01).getAsJsonArray();
                sheet02 = workbookJsonObject02.get(sheetName02).getAsJsonArray();
                for (j = 0; j < sheet01.size(); ++j) {
                    JsonArray row01 = sheet01.get(j).getAsJsonArray();
                    JsonArray row02 = sheet02.get(j).getAsJsonArray();
                    for (int k = 0; k < row01.size(); ++k) {
                        JsonObject cell01 = row01.get(k).getAsJsonObject();
                        JsonObject cell02 = row02.get(k).getAsJsonObject();
                        String cellValue01 = cell01.get(CELL_VALUE).getAsString();
                        String cellValue02 = cell02.get(CELL_VALUE).getAsString();
                        String cellFillColor01 = cell01.get(CELL_FILL_COLOR).getAsString();
                        if (cellValue01.equalsIgnoreCase(cellValue02) || !stringOprs.isEmptyOrNull(cellFillColor01) && !cellFillColor01.equalsIgnoreCase("FFFFFFFF") || !cellValueValidation) continue;
                        comparationStatus = false;
                        cellValueValidation = false;
                    }
                }
            }
        }
        this.workbookJsonObject = null;
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel: " + comparationStatus));
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel - N\u00famero de hojas: " + sheetNumberValidation));
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel - Nombres y ubicaci\u00f3n de hojas: " + sheetNamesValidation));
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel - N\u00famero de filas en cada hoja: " + rowNumberValidation));
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel - N\u00famero de columnas en cada hoja: " + columnNumberValidation));
        LOGGER.log((Priority)Level.INFO, (Object)("Resultado comparaci\u00f3n contenido de archivos excel - Valores de celda en cada hoja: " + cellValueValidation));
        return comparationStatus;
    }

    public void assertExcelFilesEquals(String expectedFilePath, String actualFilePath) {
        Assert.assertTrue((String)"Assert Excel Files Equals", (boolean)this.compareExcelFiles(expectedFilePath, actualFilePath));
    }

    public JsonObject loadWorkbookToJsonObject(String filePath) {
        JsonObject tempWorkbookJsonObject = new JsonObject();
        this.loadWorkbook(filePath);
        int numberOfSheets = this.workbook.getNumberOfSheets();
        int numberOfRows = 0;
        int numberOfColumns = 0;
        Cell cell = null;
        for (int sh = 0; sh < numberOfSheets; ++sh) {
            Sheet sheet = this.workbook.getSheetAt(sh);
            String sheetName = sheet.getSheetName();
            tempWorkbookJsonObject.add(sheetName, (JsonElement)new JsonArray(numberOfSheets));
            numberOfRows = sheet.getLastRowNum() + 1;
            if (sheet.getPhysicalNumberOfRows() <= 0) continue;
            for (int ro = 0; ro < numberOfRows; ++ro) {
                Row row = sheet.getRow(ro);
                try {
                    numberOfColumns = row.getLastCellNum();
                }
                catch (Exception e) {
                    numberOfColumns = 0;
                }
                tempWorkbookJsonObject.get(sheetName).getAsJsonArray().add((JsonElement)new JsonArray(numberOfRows));
                for (int co = 0; co < numberOfColumns; ++co) {
                    JsonObject cellJsonObject = new JsonObject();
                    cell = row.getCell(co, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    cellJsonObject.addProperty(CELL_VALUE, this.formatter.formatCellValue(cell));
                    cellJsonObject.addProperty(CELL_FILL_COLOR, this.getCellFillColorCode(cell));
                    tempWorkbookJsonObject.get(sheetName).getAsJsonArray().get(ro).getAsJsonArray().add((JsonElement)cellJsonObject);
                }
            }
        }
        this.closeWorkbook();
        return tempWorkbookJsonObject;
    }

    public String getCellFillColorCode(Cell cell) {
        String colorCode;
        try {
            colorCode = ((ExtendedColor)cell.getCellStyle().getFillForegroundColorColor()).getARGBHex();
        }
        catch (Exception e) {
            colorCode = "";
        }
        return colorCode;
    }
}

