/*
 * Decompiled with CFR 0.152.
 */
package qlc.network;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.UUID;
import qlc.network.QlcException;
import qlc.network.QlcHttpClient;
import qlc.network.QlcWebSocketClient;
import qlc.utils.StringUtil;

public class QlcClient {
    private final String url;

    public QlcClient(String url) throws MalformedURLException {
        this.url = url;
    }

    public JSONObject call(String method, JSONArray params) throws IOException {
        if (StringUtil.isBlank(this.url)) {
            throw new QlcException(3001, "Node url can`t be empty");
        }
        JSONObject reqParams = this.makeRequest(method, params);
        JSONObject response = null;
        if (this.url.toLowerCase().startsWith("http")) {
            response = this.httpReq(reqParams);
        } else if (this.url.toLowerCase().startsWith("ws")) {
            response = this.wsReq(reqParams);
        } else {
            throw new QlcException(3002, "Error node url");
        }
        if (response == null) {
            throw new QlcException(3003, "Invalid node url");
        }
        if (response.containsKey("result") || response.containsKey("error")) {
            return response;
        }
        throw new IOException();
    }

    private JSONObject makeRequest(String method, JSONArray params) {
        JSONObject request = new JSONObject();
        request.put("jsonrpc", (Object)"2.0");
        request.put("id", (Object)UUID.randomUUID().toString().replace("-", ""));
        request.put("method", (Object)method);
        request.put("params", (Object)params);
        return request;
    }

    private JSONObject httpReq(JSONObject reqParams) throws MalformedURLException {
        QlcHttpClient client = new QlcHttpClient(this.url);
        return client.send(reqParams);
    }

    private JSONObject wsReq(JSONObject reqParams) {
        QlcWebSocketClient client = new QlcWebSocketClient();
        client.startRequest(this.url);
        client.sendMessage(reqParams.toJSONString());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        String result = QlcWebSocketClient.result;
        client.closeWebSocket();
        if (StringUtil.isNotBlank(result)) {
            try {
                JSONObject json = JSONObject.parseObject(result);
                return json;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

