/*
 * Decompiled with CFR 0.152.
 */
package qlc.network;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import qlc.network.QlcException;

public class QlcHttpClient {
    private final URL url;

    public QlcHttpClient(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public JSONObject send(JSONObject params) {
        PostMethod method = new PostMethod(this.url.toString());
        try {
            method.setRequestHeader("Content-Type", "application/json");
            StringRequestEntity requestEntity = new StringRequestEntity(params.toString(), "application/json", "UTF-8");
            method.setRequestEntity(requestEntity);
            this.getHttpClient().executeMethod(method);
            int statusCode = method.getStatusCode();
            if (statusCode != 200) {
                throw new QlcException(statusCode, "");
            }
            JSONObject response = JSONObject.parseObject(method.getResponseBodyAsString());
            if (response == null) {
                throw new QlcException(900, "Invalid response type");
            }
            if (response.containsKey("result") || response.containsKey("error")) {
                JSONObject jSONObject = response;
                return jSONObject;
            }
            try {
                throw new IOException();
            }
            catch (Exception e) {
                throw new QlcException(901, e.getMessage());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getState().setCredentials(AuthScope.ANY, null);
        return client;
    }
}

