/*
 * Decompiled with CFR 0.152.
 */
package qlc.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import qlc.network.QlcException;
import qlc.utils.Checking;
import qlc.utils.Helper;

public final class MnemonicUtil {
    private MnemonicUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> seedToMnemonic(byte[] seed, MnemonicLanguage language) {
        Checking.checkSeed(seed);
        int seedLength = seed.length * 8;
        byte[] seedWithChecksum = Arrays.copyOf(seed, seed.length + 1);
        seedWithChecksum[seed.length] = MnemonicUtil.checksum(seed);
        int checksumLength = seedLength / 32;
        int mnemonicSentenceLength = (seedLength + checksumLength) / 11;
        try {
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < mnemonicSentenceLength; ++i) {
                ret.add(language.getWord(MnemonicUtil.next11Bits(seedWithChecksum, i * 11)));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            Helper.wipe(seedWithChecksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] mnemonicToSeed(List<String> mnemonic, MnemonicLanguage language) {
        Checking.check(!MnemonicUtil.isValid(mnemonic, language), "Invalid mnemonic");
        byte[] seedWithChecksum = MnemonicUtil.extractSeedWithChecksum(mnemonic, language);
        try {
            byte[] byArray = MnemonicUtil.extractSeed(seedWithChecksum);
            return byArray;
        }
        finally {
            Helper.wipe(seedWithChecksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValid(List<String> mnemonic, MnemonicLanguage language) {
        block6: {
            block5: {
                if (mnemonic.size() != 24) break block5;
                if (mnemonic.stream().allMatch(language::wordExists)) break block6;
            }
            return false;
        }
        byte[] seedWithChecksum = MnemonicUtil.extractSeedWithChecksum(mnemonic, language);
        byte[] seed = MnemonicUtil.extractSeed(seedWithChecksum);
        byte expectedChecksum = MnemonicUtil.checksum(seed);
        try {
            boolean bl = expectedChecksum == seedWithChecksum[seedWithChecksum.length - 1];
            return bl;
        }
        finally {
            Helper.wipe(seedWithChecksum);
            Helper.wipe(seed);
        }
    }

    public static List<String> toList(String mnemonics) {
        return Pattern.compile(" ").splitAsStream(mnemonics).collect(Collectors.toList());
    }

    private static byte[] extractSeedWithChecksum(List<String> mnemonic, MnemonicLanguage language) {
        int mnemonicSentenceLength = mnemonic.size();
        int seedWithChecksumLength = mnemonicSentenceLength * 11;
        byte[] seedWithChecksum = new byte[(seedWithChecksumLength + 7) / 8];
        ArrayList<Integer> mnemonicIndexes = new ArrayList<Integer>();
        for (String word : mnemonic) {
            mnemonicIndexes.add(language.getIndex(word));
        }
        for (int i = 0; i < mnemonicSentenceLength; ++i) {
            MnemonicUtil.writeNext11(seedWithChecksum, (Integer)mnemonicIndexes.get(i), i * 11);
        }
        return seedWithChecksum;
    }

    private static byte[] extractSeed(byte[] seedWithChecksum) {
        return Arrays.copyOf(seedWithChecksum, seedWithChecksum.length - 1);
    }

    private static byte checksum(byte[] seed) {
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(seed);
            byte firstByte = hash[0];
            Arrays.fill(hash, (byte)0);
            return firstByte;
        }
        catch (NoSuchAlgorithmException e) {
            throw new QlcException(1006, "Seed generation not supported");
        }
    }

    private static int next11Bits(byte[] bytes, int offset) {
        int skip = offset / 8;
        int lowerBitsToRemove = 13 - offset % 8;
        return ((bytes[skip] & 0xFF) << 16 | (bytes[skip + 1] & 0xFF) << 8 | (lowerBitsToRemove < 8 ? bytes[skip + 2] & 0xFF : 0)) >> lowerBitsToRemove & 0x7FF;
    }

    private static void writeNext11(byte[] bytes, int value, int offset) {
        int skip = offset / 8;
        int bitSkip = offset % 8;
        byte firstValue = bytes[skip];
        byte toWrite = (byte)(value >> 3 + bitSkip);
        bytes[skip] = (byte)(firstValue | toWrite);
        byte valueInByte = bytes[skip + 1];
        int i = 5 - bitSkip;
        byte toWrite2 = (byte)(i > 0 ? value << i : value >> -i);
        bytes[skip + 1] = (byte)(valueInByte | toWrite2);
        if (bitSkip >= 6) {
            valueInByte = bytes[skip + 2];
            toWrite = (byte)(value << 13 - bitSkip);
            bytes[skip + 2] = (byte)(valueInByte | toWrite);
        }
    }

    public static enum MnemonicLanguage {
        ENGLISH("english.txt");

        private final List<String> dictionary;
        private final Map<String, Integer> dictionaryMap;

        private MnemonicLanguage(String fileName) {
            try {
                ArrayList<String> tempList = new ArrayList<String>();
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("english.txt");
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String len = null;
                while ((len = br.readLine()) != null) {
                    tempList.add(len);
                    len = null;
                }
                this.dictionary = tempList;
                HashMap<String, Integer> tempDictionaryMap = new HashMap<String, Integer>();
                for (String word : this.dictionary) {
                    tempDictionaryMap.put(word, this.dictionary.indexOf(word));
                }
                this.dictionaryMap = Collections.unmodifiableMap(tempDictionaryMap);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could'nt read file " + fileName, e);
            }
        }

        public List<String> getDictionary() {
            return this.dictionary;
        }

        public Map<String, Integer> getDictionaryMap() {
            return this.dictionaryMap;
        }

        public String getWord(int index) {
            return this.dictionary.get(index);
        }

        public boolean wordExists(String word) {
            return this.dictionaryMap.containsKey(word);
        }

        public Integer getIndex(String word) {
            return this.dictionaryMap.get(word);
        }
    }
}

