/*
 * Decompiled with CFR 0.152.
 */
package qlc.utils;

import com.rfksystems.blake2b.Blake2b;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import qlc.utils.Helper;

public class WorkUtil {
    private static final Long THRESHOLD = -2199023255552L;
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    public static String generateWorkOneThread(byte[] hash) {
        byte[] pow = new byte[8];
        byte[] zero = new byte[8];
        Arrays.fill(zero, (byte)0);
        Arrays.fill(pow, (byte)0);
        Blake2b blake2b = new Blake2b(null, 8, null, null);
        byte[] output = new byte[8];
        block0: while (WorkUtil.isEqual(pow, zero)) {
            byte[] bytes = new byte[8];
            RANDOM.nextBytes(bytes);
            for (int b = -128; b < 127; b = (int)((byte)(b + 1))) {
                bytes[7] = b;
                blake2b.reset();
                blake2b.update(bytes, 0, bytes.length);
                blake2b.update(hash, 0, hash.length);
                blake2b.digest(output, 0);
                byte[] digest = Helper.reverse(output);
                if (!WorkUtil.overThreshold(digest)) continue;
                System.arraycopy(Helper.reverse(bytes), 0, pow, 0, 8);
                continue block0;
            }
        }
        return Helper.byteToHexString(pow);
    }

    public static String generateWork(final byte[] hash) {
        final byte[] pow = new byte[8];
        final byte[] zero = new byte[8];
        Arrays.fill(zero, (byte)0);
        Arrays.fill(pow, (byte)0);
        Thread[] threads = new Thread[4];
        for (int i = 0; i < 4; ++i) {
            Thread powFinder;
            threads[i] = powFinder = new Thread(){

                @Override
                public void run() {
                    Blake2b blake2b = new Blake2b(null, 8, null, null);
                    byte[] output = new byte[8];
                    block0: while (WorkUtil.isEqual(pow, zero)) {
                        byte[] bytes = new byte[8];
                        RANDOM.nextBytes(bytes);
                        for (int b = -128; b < 127; b = (int)((byte)(b + 1))) {
                            bytes[7] = b;
                            blake2b.reset();
                            blake2b.update(bytes, 0, bytes.length);
                            blake2b.update(hash, 0, hash.length);
                            blake2b.digest(output, 0);
                            byte[] digest = Helper.reverse(output);
                            if (!WorkUtil.overThreshold(digest)) continue;
                            System.arraycopy(Helper.reverse(bytes), 0, pow, 0, 8);
                            continue block0;
                        }
                    }
                }
            };
            powFinder.start();
        }
        while (WorkUtil.isEqual(pow, zero)) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Helper.byteToHexString(pow);
    }

    private static boolean isEqual(byte[] b0, byte[] b1) {
        for (int i = 0; i < b0.length; ++i) {
            if (b0[i] == b1[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean overThreshold(byte[] bytes) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(bytes[i] & 0xFF);
        }
        return Long.compareUnsigned(result, THRESHOLD) > 0;
    }
}

