/*
 * Decompiled with CFR 0.152.
 */
package qlc.rpc.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import qlc.bean.StateBlock;
import qlc.mng.TransactionMng;
import qlc.network.QlcClient;
import qlc.network.QlcException;
import qlc.rpc.QlcRpc;
import qlc.utils.Helper;
import qlc.utils.StringUtil;

public class TransactionRpc
extends QlcRpc {
    public TransactionRpc(QlcClient client) {
        super(client);
    }

    public JSONObject generateSendBlock(JSONArray params) throws IOException {
        JSONObject arrayOne = params.getJSONObject(0);
        String from = arrayOne.getString("from");
        String tokenName = arrayOne.getString("tokenName");
        String to = arrayOne.getString("to");
        BigInteger amount = arrayOne.getBigInteger("amount");
        String sender = arrayOne.getString("sender");
        String receiver = arrayOne.getString("receiver");
        String message = arrayOne.getString("message");
        String privateKey = params.getString(1);
        if (StringUtil.isBlank(from) || StringUtil.isBlank(tokenName) || StringUtil.isBlank(to) || amount == null) {
            throw new QlcException(2000, "Parameter error for send block");
        }
        if (this.client == null) {
            throw new QlcException(3000, "Need initialize qlc client");
        }
        return TransactionMng.sendBlock(this.client, from, tokenName, to, amount, sender, receiver, message, StringUtil.isNotBlank(privateKey) ? Helper.hexStringToBytes(privateKey) : null);
    }

    public JSONObject generateReceiveBlock(JSONArray params) throws IOException {
        if (params == null) {
            throw new QlcException(2001, "Parameter error for receive block");
        }
        JSONObject arrayOne = params.getJSONObject(0);
        String receiveAddress = params.getString(1);
        StateBlock sendBlock = (StateBlock)new Gson().fromJson(arrayOne.toJSONString(), StateBlock.class);
        String privateKey = null;
        if (params.size() > 2) {
            privateKey = params.getString(2);
        }
        if (StringUtil.isBlank(sendBlock.getType()) || StringUtil.isBlank(sendBlock.getToken()) || StringUtil.isBlank(sendBlock.getAddress()) || sendBlock.getBalance() == null || StringUtil.isBlank(sendBlock.getPrevious()) || StringUtil.isBlank(sendBlock.getLink()) || sendBlock.getTimestamp() == null || StringUtil.isBlank(sendBlock.getRepresentative()) || StringUtil.isBlank(receiveAddress)) {
            throw new QlcException(2001, "Parameter error for receive block");
        }
        if (this.client == null) {
            throw new QlcException(3000, "Need initialize qlc client");
        }
        return TransactionMng.receiveBlock(this.client, sendBlock, receiveAddress, StringUtil.isNotBlank(privateKey) ? Helper.hexStringToBytes(privateKey) : null);
    }

    public JSONObject generateChangeBlock(JSONArray params) throws IOException {
        String address = params.getString(0);
        String representative = params.getString(1);
        String chainTokenHash = params.getString(2);
        String privateKey = params.getString(3);
        if (StringUtil.isBlank(address) || StringUtil.isBlank(representative) || StringUtil.isBlank(chainTokenHash)) {
            throw new QlcException(2010, "Parameter error for change block");
        }
        if (this.client == null) {
            throw new QlcException(3000, "Need initialize qlc client");
        }
        return TransactionMng.changeBlock(this.client, address, representative, chainTokenHash, StringUtil.isNotBlank(privateKey) ? Helper.hexStringToBytes(privateKey) : null);
    }
}

