/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test.enums;

import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalMemcacheServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalTaskQueueTestConfig;
import com.google.appengine.tools.development.testing.LocalURLFetchServiceTestConfig;
import java.util.ArrayList;

public enum GaeServiceHelperType {
    Datastore,
    Queue,
    Memcache,
    Urlfetch;


    public static LocalDatastoreServiceTestConfig datastoreConfig() {
        return new LocalDatastoreServiceTestConfig().setApplyAllHighRepJobPolicy().setNoIndexAutoGen(true);
    }

    public static LocalMemcacheServiceTestConfig memcacheConfig() {
        return new LocalMemcacheServiceTestConfig();
    }

    public static LocalTaskQueueTestConfig queueConfig() {
        return new LocalTaskQueueTestConfig();
    }

    public static LocalURLFetchServiceTestConfig urlfetchConfig() {
        return new LocalURLFetchServiceTestConfig();
    }

    public static LocalServiceTestConfig[] allConfig() {
        return new LocalServiceTestConfig[]{GaeServiceHelperType.datastoreConfig(), GaeServiceHelperType.memcacheConfig(), GaeServiceHelperType.queueConfig()};
    }

    public static LocalServiceTestConfig[] getConfigs(GaeServiceHelperType ... types) {
        ArrayList<LocalServiceTestConfig> configs = new ArrayList<LocalServiceTestConfig>();
        for (GaeServiceHelperType type : types) {
            configs.add(type.getConfig());
        }
        return configs.toArray(new LocalServiceTestConfig[0]);
    }

    public LocalServiceTestConfig getConfig() {
        switch (this) {
            case Datastore: {
                return GaeServiceHelperType.datastoreConfig();
            }
            case Memcache: {
                return GaeServiceHelperType.memcacheConfig();
            }
            case Queue: {
                return GaeServiceHelperType.queueConfig();
            }
            case Urlfetch: {
                return GaeServiceHelperType.urlfetchConfig();
            }
        }
        return null;
    }
}

