package com.github.rameshl.appengine.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

/**
 * gae-test-util-java Created by ramesh on 2019-03-15.
 */
public class AssertException {

    /**
     * Expect illegal argument exception.
     *
     * @param runnable     the runnable
     * @param exceptionMsg the exception msg
     * @param failMsg      the fail msg
     * @throws Throwable the throwable
     */
    public static void expectIllegalArgumentException(CheckedRunnable runnable, String exceptionMsg, String failMsg) throws Throwable {
        expectException(runnable, IllegalArgumentException.class, exceptionMsg, failMsg);
    }

    /**
     * Expect exception.
     *
     * @param runnable the runnable
     * @param clazz    the clazz
     * @throws Throwable the throwable
     */
    public static void expectException(CheckedRunnable runnable, Class<? extends Exception> clazz) throws Throwable {
        expectException(runnable, clazz, null, null);
    }

    /**
     * Expect exception.
     *
     * @param runnable     the runnable
     * @param clazz        the clazz
     * @param exceptionMsg the exception msg
     * @param failMsg      the fail msg
     * @throws Throwable the throwable
     */
    public static void expectException(CheckedRunnable runnable, Class<? extends Throwable> clazz, String exceptionMsg, String failMsg) throws Throwable {

        try {
            runnable.run();

            if (failMsg == null)
                failMsg = clazz.getName() + " exception expected";

            fail(failMsg);

        } catch (Throwable ex) {
            if (!clazz.equals(ex.getClass()))
                throw ex;

            if (exceptionMsg != null) {
                assertEquals("exception message doesn't match, expected message: " + exceptionMsg + ", actual : " + ex.getMessage(), exceptionMsg, ex.getMessage());
            }
        }
    }
}
