/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.IllegalCodecNameException;
import com.buck.common.codec.StandardCodecs;
import com.buck.common.codec.UnsupportedCodecException;
import com.buck.common.codec.spi.CodecProvider;
import com.buck.commons.i18n.ResourceBundle;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import sun.misc.ASCIICaseInsensitiveComparator;

public abstract class Codec
implements Comparable<Codec> {
    private static final CodecProvider standardProvider = new StandardCodecs();
    private static volatile Object[] cache = null;
    private static final ThreadLocal<Object> gate = new ThreadLocal();
    private final String name;
    private final String[] aliases;
    private Set<String> aliasSet;

    private static Codec cache(String codecName, Codec codec) {
        cache = new Object[]{codecName, codec};
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Codec lookupViaProviders(final String codecName) {
        if (gate.get() != null) {
            return null;
        }
        try {
            gate.set(gate);
            Codec codec = AccessController.doPrivileged(new PrivilegedAction<Codec>(){

                @Override
                public Codec run() {
                    ServiceLoader<CodecProvider> sl = ServiceLoader.load(CodecProvider.class);
                    for (CodecProvider cp : sl) {
                        Codec codec = cp.codecForName(codecName);
                        if (codec == null) continue;
                        return codec;
                    }
                    return null;
                }
            });
            return codec;
        }
        finally {
            gate.set(null);
        }
    }

    private static void checkName(String s) {
        int n = s.length();
        if (n == 0) {
            Object[] arguments = new Object[]{};
            String message = ResourceBundle.formatResourceBundleMessage(Codec.class, (String)"CODEC_ILLEGAL_CODEC_NAME_ZERO_LENGTH", (Object[])arguments);
            throw new IllegalCodecNameException(message);
        }
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == ':' || c == '_' || c == '.') continue;
            Object[] arguments = new Object[]{s};
            String message = ResourceBundle.formatResourceBundleMessage(Codec.class, (String)"CODEC_ILLEGAL_CODEC_NAME", (Object[])arguments);
            throw new IllegalCodecNameException(message);
        }
    }

    private static Codec lookup(String codecName) {
        if (codecName == null) {
            Object[] arguments = new Object[]{};
            String message = ResourceBundle.formatResourceBundleMessage(Codec.class, (String)"CODEC_ILLEGAL_CODEC_NAME_IS_NULL", (Object[])arguments);
            throw new IllegalCodecNameException(message);
        }
        Object[] ca = cache;
        if (ca != null && ca[0].equals(codecName)) {
            return (Codec)ca[1];
        }
        Codec codec = standardProvider.codecForName(codecName);
        if (codec != null) {
            return Codec.cache(codecName, codec);
        }
        codec = Codec.lookupViaProviders(codecName);
        if (codec != null) {
            return Codec.cache(codecName, codec);
        }
        Codec.checkName(codecName);
        return null;
    }

    public static Codec forName(String codecName) {
        Codec codec = Codec.lookup(codecName);
        if (codec != null) {
            return codec;
        }
        Object[] arguments = new Object[]{codecName};
        String message = ResourceBundle.formatResourceBundleMessage(Codec.class, (String)"CODEC_ILLEGAL_CODEC_NAME", (Object[])arguments);
        throw new UnsupportedCodecException(message);
    }

    public static boolean isSupported(String codecName) {
        return Codec.lookup(codecName) != null;
    }

    protected Codec(String canonicalName, String[] aliases) {
        String[] as;
        Codec.checkName(canonicalName);
        for (String alias : as = aliases == null ? new String[]{} : aliases) {
            Codec.checkName(alias);
        }
        this.name = canonicalName;
        this.aliases = as;
    }

    public final Set<String> aliases() {
        if (this.aliasSet != null) {
            return this.aliasSet;
        }
        int n = this.aliases.length;
        HashSet<String> hs = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            hs.add(this.aliases[i]);
        }
        this.aliasSet = Collections.unmodifiableSet(hs);
        return this.aliasSet;
    }

    @Override
    public final int compareTo(Codec that) {
        return this.name().compareToIgnoreCase(that.name());
    }

    public final int hashCode() {
        return this.name().hashCode();
    }

    public final boolean equals(Object ob) {
        if (!(ob instanceof Codec)) {
            return false;
        }
        if (this == ob) {
            return true;
        }
        return this.name.equals(((Codec)ob).name());
    }

    public final String name() {
        return this.name;
    }

    private static void put(Iterator<Codec> i, Map<String, Codec> m) {
        while (i.hasNext()) {
            Codec codec = i.next();
            if (m.containsKey(codec.name())) continue;
            m.put(codec.name(), codec);
        }
    }

    public static SortedMap<String, Codec> availableCodecs() {
        return AccessController.doPrivileged(new PrivilegedAction<SortedMap<String, Codec>>(){

            @Override
            public SortedMap<String, Codec> run() {
                TreeMap m = new TreeMap(ASCIICaseInsensitiveComparator.CASE_INSENSITIVE_ORDER);
                Codec.put(standardProvider.codecs(), m);
                ServiceLoader<CodecProvider> sl = ServiceLoader.load(CodecProvider.class);
                for (CodecProvider cp : sl) {
                    Codec.put(cp.codecs(), m);
                }
                return Collections.unmodifiableSortedMap(m);
            }
        });
    }

    public abstract CodecDecoder newDecoder();

    public abstract CodecEncoder newEncoder();
}

