/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.spi.CodecProvider;
import java.util.Iterator;
import java.util.Map;

public class FastCodecProvider
extends CodecProvider {
    private final Map<String, String> classMap;
    private final Map<String, String> aliasMap;
    private final Map<String, Codec> cache;
    private final String packagePrefix;

    protected FastCodecProvider(String pp, Map<String, String> am, Map<String, String> cm, Map<String, Codec> c) {
        this.packagePrefix = pp;
        this.aliasMap = am;
        this.classMap = cm;
        this.cache = c;
    }

    private String canonicalize(String cn) {
        String an = this.aliasMap.get(cn);
        return an != null ? an : cn;
    }

    private Codec lookup(String codecName) {
        String cn = this.canonicalize(codecName.toLowerCase());
        Codec codec = this.cache.get(cn);
        if (codec != null) {
            return codec;
        }
        String cln = this.classMap.get(cn);
        if (cln == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(this.packagePrefix + "." + cln, true, this.getClass().getClassLoader());
            codec = (Codec)c.newInstance();
            this.cache.put(cn, codec);
            return codec;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
        catch (IllegalAccessException x) {
            return null;
        }
        catch (InstantiationException x) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Codec codecForName(String codecName) {
        FastCodecProvider fastCodecProvider = this;
        synchronized (fastCodecProvider) {
            return this.lookup(this.canonicalize(codecName));
        }
    }

    @Override
    public final Iterator<Codec> codecs() {
        return new Iterator<Codec>(){
            final Iterator<String> i;
            {
                this.i = FastCodecProvider.this.classMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Codec next() {
                String cn = this.i.next();
                return FastCodecProvider.this.lookup(cn);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

