/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.algorithms;

import com.buck.commons.i18n.ResourceBundle;

public final class BinaryData {
    public static final int sizeOfByte = 1;
    public static final int sizeOfShort = 2;
    public static final int sizeOfInt = 4;
    public static final int sizeOfLong = 8;

    public static void storeByteAtOffset(byte[] array, int offset, byte value) throws IndexOutOfBoundsException {
        if (offset < 0 || offset > array.length - sizeOfByte) {
            Object[] arguments = new Object[]{array.length, offset};
            String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_WRITE_ERROR", arguments);
            throw new IndexOutOfBoundsException(message);
        }
        BinaryData.storeByteAtOffsetUnsafe(array, offset, value);
    }

    public static void storeByteAtOffsetUnsafe(byte[] array, int offset, byte value) {
        array[offset] = value;
    }

    public static byte loadByteAtOffset(byte[] array, int offset) throws IndexOutOfBoundsException {
        if (offset >= 0 && offset <= array.length - sizeOfByte) {
            return BinaryData.loadByteAtOffsetUnsafe(array, offset);
        }
        Object[] arguments = new Object[]{array.length, offset};
        String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_READ_ERROR", arguments);
        throw new IndexOutOfBoundsException(message);
    }

    public static byte loadByteAtOffsetUnsafe(byte[] array, int offset) {
        return array[offset];
    }

    public static void storeShortAtOffset(byte[] array, int offset, short value) throws IndexOutOfBoundsException {
        if (offset < 0 || offset > array.length - sizeOfShort) {
            Object[] arguments = new Object[]{array.length, offset};
            String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_WRITE_ERROR", arguments);
            throw new IndexOutOfBoundsException(message);
        }
        BinaryData.storeShortAtOffsetUnsafe(array, offset, value);
    }

    public static void storeShortAtOffsetUnsafe(byte[] array, int offset, short value) {
        array[offset] = (byte)(value >>> 8);
        array[offset + 1] = (byte)(value & 0xFF);
    }

    public static short loadShortAtOffset(byte[] array, int offset) throws IndexOutOfBoundsException {
        if (offset >= 0 && offset <= array.length - sizeOfShort) {
            return BinaryData.loadShortAtOffsetUnsafe(array, offset);
        }
        Object[] arguments = new Object[]{array.length, offset};
        String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_READ_ERROR", arguments);
        throw new IndexOutOfBoundsException(message);
    }

    public static short loadShortAtOffsetUnsafe(byte[] array, int offset) {
        return (short)((array[offset] & 0xFF) << 8 | array[offset + 1] & 0xFF);
    }

    public static void storeIntAtOffset(byte[] array, int offset, int value) throws IndexOutOfBoundsException {
        if (offset < 0 || offset > array.length - sizeOfInt) {
            Object[] arguments = new Object[]{array.length, offset};
            String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_WRITE_ERROR", arguments);
            throw new IndexOutOfBoundsException(message);
        }
        BinaryData.storeIntAtOffsetUnsafe(array, offset, value);
    }

    public static void storeIntAtOffsetUnsafe(byte[] array, int offset, int value) {
        array[offset] = (byte)(value >>> 24);
        array[offset + 1] = (byte)(value >>> 16);
        array[offset + 2] = (byte)(value >>> 8);
        array[offset + 3] = (byte)(value & 0xFF);
    }

    public static int loadIntAtOffset(byte[] array, int offset) throws IndexOutOfBoundsException {
        if (offset >= 0 && offset <= array.length - sizeOfInt) {
            return BinaryData.loadIntAtOffsetUnsafe(array, offset);
        }
        Object[] arguments = new Object[]{array.length, offset};
        String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_READ_ERROR", arguments);
        throw new IndexOutOfBoundsException(message);
    }

    public static int loadIntAtOffsetUnsafe(byte[] array, int offset) {
        return (array[offset] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF;
    }

    public static void storeLongAtOffset(byte[] array, int offset, long value) throws IndexOutOfBoundsException {
        if (offset < 0 || offset > array.length - sizeOfLong) {
            Object[] arguments = new Object[]{array.length, offset};
            String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_WRITE_ERROR", arguments);
            throw new IndexOutOfBoundsException(message);
        }
        BinaryData.storeLongAtOffsetUnsafe(array, offset, value);
    }

    public static void storeLongAtOffsetUnsafe(byte[] array, int offset, long value) {
        array[offset] = (byte)(value >>> 56);
        array[offset + 1] = (byte)(value >>> 48);
        array[offset + 2] = (byte)(value >>> 40);
        array[offset + 3] = (byte)(value >>> 32);
        array[offset + 4] = (byte)(value >>> 24);
        array[offset + 5] = (byte)(value >>> 16);
        array[offset + 6] = (byte)(value >>> 8);
        array[offset + 7] = (byte)(value & 0xFFL);
    }

    public static long loadLongAtOffset(byte[] array, int offset) throws IndexOutOfBoundsException {
        if (offset >= 0 && offset <= array.length - sizeOfLong) {
            return BinaryData.loadLongAtOffsetUnsafe(array, offset);
        }
        Object[] arguments = new Object[]{array.length, offset};
        String message = ResourceBundle.formatResourceBundleMessage(BinaryData.class, "BINARY_DATA_ARRAY_BOUNDS_READ_ERROR", arguments);
        throw new IndexOutOfBoundsException(message);
    }

    public static long loadLongAtOffsetUnsafe(byte[] array, int offset) {
        return ((long)array[offset] & 0xFFL) << 56 | ((long)array[offset + 1] & 0xFFL) << 48 | ((long)array[offset + 2] & 0xFFL) << 40 | ((long)array[offset + 3] & 0xFFL) << 32 | ((long)array[offset + 4] & 0xFFL) << 24 | ((long)array[offset + 5] & 0xFFL) << 16 | ((long)array[offset + 6] & 0xFFL) << 8 | (long)array[offset + 7] & 0xFFL;
    }
}

