/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.algorithms;

import com.buck.commons.algorithms.BinaryData;
import com.buck.commons.i18n.ResourceBundle;
import java.io.File;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;

public final class SystemEntropy {
    private static byte[] longToByteArray(long l) {
        byte[] retVal = new byte[8];
        for (int i = 0; i < 8; ++i) {
            retVal[i] = (byte)l;
            l >>= 8;
        }
        return retVal;
    }

    public static byte[] getSystemEntropy() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            Object[] args = new Object[]{};
            String message = ResourceBundle.formatResourceBundleMessage(SystemEntropy.class, "SHA1_UNAVAILABLE", args);
            throw new InternalError(message);
        }
        byte[] time = new byte[8];
        BinaryData.storeLongAtOffset(time, 0, System.nanoTime());
        md.update(time);
        byte[] tid = new byte[8];
        BinaryData.storeLongAtOffset(tid, 0, Thread.currentThread().getId());
        md.update(tid);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    String[] sa;
                    Properties p = System.getProperties();
                    Enumeration<?> e = p.propertyNames();
                    while (e.hasMoreElements()) {
                        String s = (String)e.nextElement();
                        md.update(s.getBytes("UTF-8"));
                        md.update(p.getProperty(s).getBytes("UTF-8"));
                    }
                    md.update(InetAddress.getLocalHost().toString().getBytes("UTF-8"));
                    File f = new File(p.getProperty("java.io.tmpdir"));
                    for (String aSa : sa = f.list()) {
                        md.update(aSa.getBytes("UTF-8"));
                    }
                }
                catch (Exception ex) {
                    md.update((byte)ex.hashCode());
                }
                Runtime rt = Runtime.getRuntime();
                byte[] memBytes = SystemEntropy.longToByteArray(rt.totalMemory());
                md.update(memBytes, 0, memBytes.length);
                memBytes = SystemEntropy.longToByteArray(rt.freeMemory());
                md.update(memBytes, 0, memBytes.length);
                return null;
            }
        });
        return md.digest();
    }
}

