/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;

public final class ResourceBundle {
    private static final Logger logger = Logger.getLogger(ResourceBundle.class);

    public static java.util.ResourceBundle getResourceBundle(String baseName) {
        return java.util.ResourceBundle.getBundle(baseName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
    }

    public static java.util.ResourceBundle getResourceBundle(Class c) {
        if (c.isArray()) {
            Object[] arguments = new Object[]{};
            String message = ResourceBundle.formatResourceBundleMessage(ResourceBundle.class, "ARRAYS_HAVE_NO_ASSOCIATED_PACKAGE", arguments);
            throw new IllegalArgumentException(message);
        }
        String className = c.getName();
        int pkgEndIndex = className.lastIndexOf(46);
        String packageName = pkgEndIndex < 0 ? "" : className.substring(0, pkgEndIndex);
        String baseName = packageName.replace('.', '/') + "/resource";
        return ResourceBundle.getResourceBundle(baseName);
    }

    public static String formatResourceBundleMessage(Class c, String mnemonic, Object[] arguments) {
        java.util.ResourceBundle rb = ResourceBundle.getResourceBundle(c);
        try {
            String pattern = rb.getString(mnemonic);
            return MessageFormat.format(pattern, arguments);
        }
        catch (MissingResourceException e) {
            Object[] fmtargs = new Object[]{mnemonic, c.getPackage().getName()};
            String message = ResourceBundle.formatResourceBundleMessage(ResourceBundle.class, "MISSING_RESOURCE_EXCEPTION", fmtargs);
            logger.error((Object)message);
            return mnemonic;
        }
    }
}

