/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.i18n;

import com.buck.commons.i18n.ResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TimeZoneFile {
    private static final Logger logger = Logger.getLogger(TimeZoneFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone[] getTimeZoneIds(String timeZoneFile) {
        block7: {
            File file = new File(timeZoneFile);
            if (file.exists()) {
                TimeZone[] timeZoneArray;
                FileInputStream inputStream = new FileInputStream(timeZoneFile);
                try {
                    timeZoneArray = TimeZoneFile.getTimeZoneIds(inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        Object[] formatArgs = new Object[]{timeZoneFile, e.getMessage()};
                        String message = ResourceBundle.formatResourceBundleMessage(TimeZoneFile.class, "MISSING_TIMEZONE_FILE_EXCEPTION", formatArgs);
                        logger.error((Object)message);
                        break block7;
                    }
                    catch (IOException e) {
                        Object[] formatArgs = new Object[]{timeZoneFile, e.getMessage()};
                        String message = ResourceBundle.formatResourceBundleMessage(TimeZoneFile.class, "UNKNOWN_TIMEZONE_FILE_EXCEPTION", formatArgs);
                        logger.error((Object)message);
                    }
                }
                inputStream.close();
                return timeZoneArray;
            }
        }
        return null;
    }

    public static TimeZone[] getTimeZoneIds(InputStream tzInputStream) {
        String[] timeZoneIds = TimeZoneFile.parseTimeZoneFile(tzInputStream);
        class TimeZoneIdComparator
        implements Comparator<TimeZone>,
        Serializable {
            private static final long serialVersionUID = -899787199207258879L;

            TimeZoneIdComparator() {
            }

            @Override
            public int compare(TimeZone lhs, TimeZone rhs) {
                return lhs.getID().compareTo(rhs.getID());
            }
        }
        TreeSet<TimeZone> timeZoneSet = new TreeSet<TimeZone>(new TimeZoneIdComparator());
        if (timeZoneIds != null && timeZoneIds.length != 0) {
            for (String timeZoneId : timeZoneIds) {
                timeZoneSet.add(TimeZone.getTimeZone(timeZoneId));
            }
        } else {
            timeZoneSet.add(TimeZone.getDefault());
        }
        ArrayList<TimeZone> list = new ArrayList<TimeZone>(timeZoneSet);
        class TimeZoneRawOffsetComparator
        implements Comparator<TimeZone>,
        Serializable {
            private static final long serialVersionUID = 786814863252198070L;

            TimeZoneRawOffsetComparator() {
            }

            @Override
            public int compare(TimeZone lhs, TimeZone rhs) {
                int rhsRawOffset;
                int lhsRawOffset = lhs.getRawOffset();
                return lhsRawOffset > (rhsRawOffset = rhs.getRawOffset()) ? -1 : (lhsRawOffset == rhsRawOffset ? 0 : 1);
            }
        }
        Collections.sort(list, new TimeZoneRawOffsetComparator());
        TimeZone[] timeZones = new TimeZone[list.size()];
        return list.toArray(timeZones);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] parseTimeZoneFile(InputStream tzInputStream) {
        if (tzInputStream == null) {
            return null;
        }
        TreeSet<String> validTimeZones = new TreeSet<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(tzInputStream, "US-ASCII"));
            try {
                String line;
                do {
                    if ((line = br.readLine()) == null || (line = line.trim()).length() == 0 || '#' == line.charAt(0) || !TimeZoneFile.isTimeZoneWellFormed(line)) continue;
                    validTimeZones.add(line);
                } while (line != null);
            }
            catch (IOException ioe) {
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException ioe2) {}
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int countTimeZones = validTimeZones.size();
        String[] timeZones = new String[countTimeZones];
        int i = 0;
        Iterator i$ = validTimeZones.iterator();
        while (i$.hasNext()) {
            String timeZone = (String)i$.next();
            timeZones[i++] = timeZone;
        }
        return timeZones;
    }

    private static boolean isTimeZoneWellFormed(String text) {
        boolean isValid = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '/' || c == '-' || c == '_') continue;
            isValid = false;
            break;
        }
        return isValid;
    }
}

