/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    protected int position;
    protected int mark = 0;
    protected int limit = -1;
    protected final int count;

    public ByteBufferInputStream(ByteBuffer b) {
        this.buffer = b;
        this.position = 0;
        this.count = b.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (readLimit > this.buffer.remaining() || readLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.mark = this.position;
        this.limit = this.position + readLimit;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            this.position = 0;
            this.buffer.position(this.position);
        } else {
            this.position = this.mark;
            this.buffer.position(this.mark);
            this.mark = -1;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            int bv = this.buffer.get() & 0xFF;
            ++this.position;
            if (this.mark != -1 && this.position >= this.limit) {
                this.mark = -1;
            }
            return bv;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= this.count) {
            return -1;
        }
        if (this.position + len > this.count) {
            len = this.count - this.position;
        }
        if (len <= 0) {
            return 0;
        }
        this.buffer.get(b, off, len);
        this.position += len;
        if (this.mark != -1 && this.position >= this.limit) {
            this.mark = -1;
        }
        return len;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if ((long)this.position + n > (long)this.count) {
            n = this.count - this.position;
        }
        if (n < 0L) {
            return 0L;
        }
        this.position = (int)((long)this.position + n);
        if (this.mark != -1 && this.position >= this.limit) {
            this.mark = -1;
        }
        this.buffer.position(this.position);
        return n;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
    }
}

