/*
 * Decompiled with CFR 0.152.
 */
package com.buck.commons.io;

import com.buck.commons.i18n.ResourceBundle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;

public class ByteBufferOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger(ByteBufferOutputStream.class);
    protected ByteBuffer buffer;
    protected final boolean grow;

    public ByteBufferOutputStream() {
        this(1);
    }

    public ByteBufferOutputStream(int size) {
        this(ByteBuffer.allocate(size), true);
    }

    public ByteBufferOutputStream(int size, boolean grow) {
        this(ByteBuffer.allocate(size), grow);
    }

    public ByteBufferOutputStream(byte[] backing) {
        this(ByteBuffer.wrap(backing), false);
    }

    public ByteBufferOutputStream(byte[] backing, int pos, int length) {
        this(ByteBuffer.wrap(backing, pos, length), false);
    }

    public ByteBufferOutputStream(ByteBuffer backing) {
        this(backing, false);
    }

    public ByteBufferOutputStream(ByteBuffer backing, boolean grow) {
        this.buffer = backing;
        this.grow = grow;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void writeTo(ByteBuffer sink) {
        this.buffer.flip();
        sink.put(this.buffer);
        this.buffer.compact();
    }

    public void writeTo(byte[] out) {
        this.writeTo(out, 0, out.length);
    }

    public void writeTo(byte[] out, int off, int len) {
        this.buffer.flip();
        this.buffer.get(out, off, len);
        this.buffer.compact();
    }

    private void grow(int len) {
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + len);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    public void write(ByteBuffer src) {
        if (this.grow && src.remaining() > this.buffer.remaining()) {
            this.grow(src.remaining());
        }
        this.buffer.put(src);
    }

    @Override
    public void write(int b) {
        if (this.grow && !this.buffer.hasRemaining()) {
            this.grow(1);
        }
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.grow && len > this.buffer.remaining()) {
            this.grow(len);
        }
        this.buffer.put(b, off, len);
    }

    public void writeTo(OutputStream out) throws IOException {
        int limit = this.buffer.limit();
        int position = this.buffer.position();
        WritableByteChannel channel = Channels.newChannel(out);
        this.buffer.flip();
        channel.write(this.buffer);
        this.buffer.limit(limit);
        this.buffer.position(position);
    }

    public void reset() {
        this.buffer.clear();
    }

    public byte[] toByteArray() {
        int limit = this.buffer.limit();
        int position = this.buffer.position();
        byte[] out = new byte[position];
        this.buffer.flip();
        this.buffer.get(out);
        this.buffer.limit(limit);
        this.buffer.position(position);
        return out;
    }

    public int size() {
        return this.buffer.position();
    }

    public String toString() {
        String csn = Charset.defaultCharset().name();
        try {
            return this.toString(csn);
        }
        catch (UnsupportedEncodingException e) {
            String message;
            Object[] arguments;
            if (logger.isDebugEnabled()) {
                arguments = new Object[]{csn};
                message = ResourceBundle.formatResourceBundleMessage(ByteBufferOutputStream.class, "BBOS_UNSUPPORTED_CSN", arguments);
                logger.debug((Object)message);
            }
            try {
                csn = "ISO-8859-1";
                return this.toString(csn);
            }
            catch (UnsupportedEncodingException e2) {
                arguments = new Object[]{e2.toString()};
                message = ResourceBundle.formatResourceBundleMessage(ByteBufferOutputStream.class, "BBOS_ISO88591_UNAVAILABLE", arguments);
                logger.error((Object)message);
                throw new InternalError(message);
            }
        }
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        if (this.buffer.hasArray()) {
            return new String(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.position(), enc);
        }
        return new String(this.toByteArray(), enc);
    }

    @Override
    public void close() throws IOException {
    }
}

