/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.RetryState;
import com.github.rbuck.retry.RetryStrategy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoff
implements RetryStrategy {
    public static final int DEFAULT_RETRY_COUNT = 10;
    public static final long DEFAULT_MIN_BACKOFF = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
    public static final long DEFAULT_MAX_BACKOFF = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    public static final long DEFAULT_SLOT_TIME = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS);
    private final Random random = new Random(1L);
    private final int maxRetries;
    private final long minBackoff;
    private final long maxBackoff;
    private final long slotTime;

    public ExponentialBackoff() {
        this(10, DEFAULT_MIN_BACKOFF, DEFAULT_MAX_BACKOFF, DEFAULT_SLOT_TIME);
    }

    public ExponentialBackoff(int maxRetries, long minBackoff, long maxBackoff, long slotTime) {
        this.maxRetries = maxRetries;
        this.minBackoff = minBackoff;
        this.maxBackoff = maxBackoff;
        this.slotTime = slotTime;
    }

    public ExponentialBackoff(int maxRetries) {
        this(maxRetries, DEFAULT_MIN_BACKOFF, DEFAULT_MAX_BACKOFF, DEFAULT_SLOT_TIME);
    }

    @Override
    public RetryState getRetryState() {
        return new RetryState(){
            private int retryCount;

            @Override
            public void delayRetry() {
                RetryState.RetryStateCommon.addDelay(this.getRetryDelay());
            }

            @Override
            public boolean hasRetries() {
                if (this.retryCount < ExponentialBackoff.this.maxRetries) {
                    ++this.retryCount;
                    return true;
                }
                return false;
            }

            @Override
            public int getRetryCount() {
                return this.retryCount;
            }

            @Override
            public long getRetryDelay() {
                int MAX_CONTENTION_PERIODS = 10;
                return this.retryCount == 0 ? 0L : Math.min(ExponentialBackoff.this.minBackoff + (long)ExponentialBackoff.this.random.nextInt(2 << Math.min(this.retryCount, 9)) * ExponentialBackoff.this.slotTime, ExponentialBackoff.this.maxBackoff);
            }
        };
    }
}

