/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.RetryState;
import com.github.rbuck.retry.RetryStrategy;

public class FixedInterval
implements RetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public FixedInterval(int maxRetries, long retryInterval) {
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    @Override
    public RetryState getRetryState() {
        return new RetryState(){
            private int retryCount;

            @Override
            public void delayRetry() {
                RetryState.RetryStateCommon.addDelay(this.getRetryDelay());
            }

            @Override
            public boolean hasRetries() {
                if (this.retryCount < FixedInterval.this.maxRetries) {
                    ++this.retryCount;
                    return true;
                }
                return false;
            }

            @Override
            public int getRetryCount() {
                return this.retryCount;
            }

            @Override
            public long getRetryDelay() {
                return FixedInterval.this.retryInterval;
            }
        };
    }
}

