/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.RetryState;
import com.github.rbuck.retry.RetryStrategy;

public class Incremental
implements RetryStrategy {
    private final int maxRetries;
    private final long initialInterval;
    private final long incrementalInterval;

    public Incremental(int maxRetries, long initialInterval, long incrementalInterval) {
        this.maxRetries = maxRetries;
        this.initialInterval = initialInterval;
        this.incrementalInterval = incrementalInterval;
    }

    @Override
    public RetryState getRetryState() {
        return new RetryState(){
            private int retryCount;

            @Override
            public void delayRetry() {
                RetryState.RetryStateCommon.addDelay(this.getRetryDelay());
            }

            @Override
            public boolean hasRetries() {
                if (this.retryCount < Incremental.this.maxRetries) {
                    ++this.retryCount;
                    return true;
                }
                return false;
            }

            @Override
            public int getRetryCount() {
                return this.retryCount;
            }

            @Override
            public long getRetryDelay() {
                return Incremental.this.initialInterval + Incremental.this.incrementalInterval * (long)this.retryCount;
            }
        };
    }
}

