/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.RetryEvent;
import com.github.rbuck.retry.RetryEventListener;
import com.github.rbuck.retry.RetryState;
import com.github.rbuck.retry.RetryStrategy;
import com.github.rbuck.retry.TransientExceptionDetector;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class RetryPolicy<V> {
    private final RetryStrategy retryStrategy;
    private final TransientExceptionDetector transientExceptionDetector;
    private RetryEventListener[] retryListeners = new RetryEventListener[0];
    private static final List<RetryEvent> eventQueue = new LinkedList<RetryEvent>();
    private static Thread eventDispatchThread = null;

    public RetryPolicy(RetryStrategy retryStrategy, TransientExceptionDetector transientExceptionDetector) {
        this.retryStrategy = retryStrategy;
        this.transientExceptionDetector = transientExceptionDetector;
    }

    public V action(Callable<V> callable) throws Exception {
        RetryState retryState = this.retryStrategy.getRetryState();
        while (true) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                Exception re = e;
                if (Thread.interrupted() || this.isInterruptTransitively(e)) {
                    re = new InterruptedException(e.getMessage());
                } else if (this.transientExceptionDetector.isTransient(e)) {
                    this.enqueueRetryEvent(new RetryEvent(this, retryState, re));
                    retryState.delayRetry();
                    if (retryState.hasRetries()) continue;
                }
                throw re;
            }
            break;
        }
    }

    private boolean isInterruptTransitively(Throwable e) {
        do {
            if (!(e instanceof InterruptedException)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    private synchronized RetryEventListener[] retryListeners() {
        return this.retryListeners;
    }

    public synchronized void addRetryEventListener(RetryEventListener rel) {
        if (rel == null) {
            throw new IllegalArgumentException("Attempt to set null retry event listener");
        }
        RetryEventListener[] old = this.retryListeners;
        this.retryListeners = new RetryEventListener[old.length + 1];
        System.arraycopy(old, 0, this.retryListeners, 0, old.length);
        this.retryListeners[old.length] = rel;
        RetryPolicy.startEventDispatchThreadIfNecessary();
    }

    private static synchronized void startEventDispatchThreadIfNecessary() {
        if (eventDispatchThread == null) {
            eventDispatchThread = new EventDispatchThread();
            eventDispatchThread.setDaemon(true);
            eventDispatchThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueRetryEvent(RetryEvent event) {
        if (this.retryListeners.length != 0) {
            List<RetryEvent> list = eventQueue;
            synchronized (list) {
                eventQueue.add(event);
                eventQueue.notify();
            }
        }
    }

    private static class EventDispatchThread
    extends Thread {
        private EventDispatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (true) {
                RetryEventListener[] listeners;
                RetryEvent event;
                List list = eventQueue;
                synchronized (list) {
                    try {
                        while (eventQueue.isEmpty()) {
                            eventQueue.wait();
                        }
                        event = (RetryEvent)eventQueue.remove(0);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                RetryPolicy src = (RetryPolicy)event.getSource();
                RetryEventListener[] arr$ = listeners = src.retryListeners();
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block5;
                    RetryEventListener listener = arr$[i$];
                    listener.onRetry(event);
                    ++i$;
                }
                break;
            }
        }
    }
}

