/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.RetryPolicy;
import com.github.rbuck.retry.RetryStrategy;
import com.github.rbuck.retry.SqlCallable;
import com.github.rbuck.retry.SqlTransactionContext;
import com.github.rbuck.retry.SqlTransientExceptionDetector;
import com.github.rbuck.retry.TransientExceptionDetector;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public class SqlRetryPolicy<V> {
    private final SqlTransactionContext sqlTransactionContext;
    private final RetryPolicy<V> retryPolicy;

    public SqlRetryPolicy(RetryStrategy retryStrategy, SqlTransactionContext sqlTransactionContext) {
        this(retryStrategy, new SqlTransientExceptionDetector(), sqlTransactionContext);
    }

    public SqlRetryPolicy(RetryStrategy retryStrategy, TransientExceptionDetector transientExceptionDetector, SqlTransactionContext sqlTransactionContext) {
        this.retryPolicy = new RetryPolicy(retryStrategy, transientExceptionDetector);
        this.sqlTransactionContext = sqlTransactionContext;
    }

    public V action(final SqlCallable<V> callable) throws Exception {
        return this.retryPolicy.action(new Callable<V>(){

            @Override
            public V call() throws Exception {
                Throwable throwable = null;
                try (Connection connection = SqlRetryPolicy.this.sqlTransactionContext.getConnection();){
                    Object value = callable.call(connection);
                    connection.commit();
                    Object v = value;
                    return v;
                }
                catch (SQLException se) {
                    try {
                        if (!SqlTransientExceptionDetector.isSqlStateConnectionException(se)) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException ignored) {
                                // empty catch block
                            }
                        }
                        throw se;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        });
    }
}

