/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry;

import com.github.rbuck.retry.TransientExceptionDetector;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;

public class SqlTransientExceptionDetector
implements TransientExceptionDetector {
    private final boolean treatDuplicatesAsTransient;

    public SqlTransientExceptionDetector() {
        this(true);
    }

    public SqlTransientExceptionDetector(boolean treatDuplicatesAsTransient) {
        this.treatDuplicatesAsTransient = treatDuplicatesAsTransient;
    }

    @Override
    public boolean isTransient(Exception e) {
        if (e instanceof SQLTransientException || e instanceof SQLRecoverableException) {
            return true;
        }
        if (e instanceof SQLNonTransientException) {
            return false;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (SqlTransientExceptionDetector.isSqlStateConnectionException(se) || SqlTransientExceptionDetector.isSqlStateRollbackException(se)) {
                return true;
            }
            if (SqlTransientExceptionDetector.isSqlStateDuplicateValueInUniqueIndex(se) && this.treatDuplicatesAsTransient) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSqlStateDuplicateValueInUniqueIndex(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && (sqlState.equals("23505") || se.getMessage().contains("duplicate value in unique index"));
    }

    public static boolean isSqlStateConnectionException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.startsWith("08");
    }

    public static boolean isSqlStateRollbackException(SQLException se) {
        String sqlState = se.getSQLState();
        return sqlState != null && sqlState.startsWith("40");
    }
}

