/*
 * Decompiled with CFR 0.152.
 */
package com.github.rbuck.retry.hibernate;

import com.github.rbuck.retry.SqlTransientExceptionDetector;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;

public class HibernateTransientExceptionDetector
extends SqlTransientExceptionDetector {
    @Override
    public boolean isTransient(Exception e) {
        if (e instanceof LockAcquisitionException || e instanceof PessimisticLockException || e instanceof JDBCConnectionException) {
            return true;
        }
        if (e instanceof GenericJDBCException) {
            JDBCException se = (JDBCException)e;
            return super.isTransient(se.getSQLException());
        }
        return false;
    }
}

