/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.viewmodels;

import io.reactivesprint.rx.Command;
import io.reactivesprint.rx.ICommand;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.rx.Pair;
import io.reactivesprint.rx.Property;
import io.reactivesprint.viewmodels.ArrayViewModel;
import io.reactivesprint.viewmodels.IFetchedArrayViewModel;
import io.reactivesprint.viewmodels.IViewModel;
import java.util.ArrayList;
import java.util.Collection;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public abstract class FetchedArrayViewModel<E extends IViewModel, P>
extends ArrayViewModel<E>
implements IFetchedArrayViewModel<E, P, Void, Collection<E>> {
    private final MutableProperty<Boolean> refreshing = new MutableProperty<Boolean>(false);
    private final MutableProperty<Boolean> fetchingNextPage = new MutableProperty<Boolean>(false);
    private final MutableProperty<Boolean> hasNextPage = new MutableProperty<Boolean>(true);
    private P nextPage;
    private final ICommand<Void, Collection<E>> refreshCommand;
    private final ICommand<Void, Collection<E>> fetchCommand = this.createFetchCommand();
    private final ICommand<Void, Collection<E>> fetchIfNeededCommand;

    public FetchedArrayViewModel() {
        this.refreshCommand = this.createRefreshCommand();
        this.fetchIfNeededCommand = this.createFetchIfNeededCommand();
    }

    protected abstract Observable<Pair<P, Collection<E>>> onFetch(P var1);

    @Override
    public final IProperty<Boolean> refreshing() {
        return new Property<Boolean>(this.refreshing);
    }

    @Override
    public P getNextPage() {
        return this.nextPage;
    }

    protected void setNextPage(P nextPage) {
        this.nextPage = nextPage;
    }

    @Override
    public final IProperty<Boolean> fetchingNextPage() {
        return new Property<Boolean>(this.fetchingNextPage);
    }

    @Override
    public final IProperty<Boolean> hasNextPage() {
        return new Property<Boolean>(this.hasNextPage);
    }

    @Override
    public final ICommand<Void, Collection<E>> getRefreshCommand() {
        return this.refreshCommand;
    }

    @Override
    public final ICommand<Void, Collection<E>> getFetchCommand() {
        return this.fetchCommand;
    }

    @Override
    public final ICommand<Void, Collection<E>> getFetchIfNeededCommand() {
        return this.fetchIfNeededCommand;
    }

    protected ICommand<Void, Collection<E>> createRefreshCommand() {
        Command<Void, Collection<E>> command = new Command<Void, Collection<E>>(this.enabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void aVoid) {
                FetchedArrayViewModel.this.refreshing.setValue(true);
                return FetchedArrayViewModel.this.fetch(null);
            }
        });
        this.bindCommand(command);
        return command;
    }

    protected ICommand<Void, Collection<E>> createFetchCommand() {
        Command<Void, Collection<E>> command = new Command<Void, Collection<E>>(this.enabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void aVoid) {
                if (FetchedArrayViewModel.this.nextPage != null) {
                    FetchedArrayViewModel.this.fetchingNextPage.setValue(true);
                } else {
                    FetchedArrayViewModel.this.refreshing.setValue(true);
                }
                return FetchedArrayViewModel.this.fetch(FetchedArrayViewModel.this.nextPage);
            }
        });
        this.bindCommand(command);
        return command;
    }

    protected ICommand<Void, Collection<E>> createFetchIfNeededCommand() {
        return new Command<Void, Collection<E>>(this.enabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void input) {
                if (FetchedArrayViewModel.this.getNextPage() != null && FetchedArrayViewModel.this.hasNextPage().getValue().booleanValue()) {
                    return FetchedArrayViewModel.this.getFetchCommand().apply(input);
                }
                return Observable.empty();
            }
        });
    }

    private Observable<Collection<E>> fetch(P nextPage) {
        return this.onFetch(nextPage).doOnNext(new Action1<Pair<P, Collection<E>>>(){

            public void call(Pair<P, Collection<E>> objects) {
                ArrayList newViewModels = new ArrayList();
                if (!((Boolean)FetchedArrayViewModel.this.refreshing.getValue()).booleanValue()) {
                    newViewModels.addAll(FetchedArrayViewModel.this.getViewModels());
                }
                newViewModels.addAll(objects.getValue1());
                FetchedArrayViewModel.this.setViewModels(newViewModels);
                FetchedArrayViewModel.this.hasNextPage.setValue(!objects.getValue1().isEmpty());
                FetchedArrayViewModel.this.nextPage = objects.getValue0();
            }
        }).doAfterTerminate(new Action0(){

            public void call() {
                FetchedArrayViewModel.this.refreshing.setValue(false);
                FetchedArrayViewModel.this.fetchingNextPage.setValue(false);
            }
        }).map(new Func1<Pair<P, Collection<E>>, Collection<E>>(){

            public Collection<E> call(Pair<P, Collection<E>> objects) {
                return objects.getValue1();
            }
        });
    }
}

