/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import rx.Observable;

public final class Property<V>
implements IProperty<V> {
    private final IProperty<V> property;

    public Property(IProperty<V> property) {
        Preconditions.checkNotNull(property, "property");
        this.property = property;
    }

    public Property(V initialValue, Observable<V> observable) {
        Preconditions.checkNotNull(observable, "observable");
        MutableProperty<V> property = new MutableProperty<V>(initialValue);
        property.bind(observable);
        this.property = property;
    }

    @Override
    public V getValue() {
        return this.property.getValue();
    }

    @Override
    public Observable<V> getObservable() {
        return this.property.getObservable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property1 = (Property)o;
        return this.property.equals(property1.property);
    }

    public int hashCode() {
        return this.property.hashCode();
    }

    public String toString() {
        return "Property{property=" + this.property + '}';
    }
}

