/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx.functions;

import io.reactivesprint.Preconditions;
import java.util.Comparator;
import rx.functions.Func1;

public class Func1Comparator<T>
implements Func1<T, Boolean> {
    public static final int GREATER_THAN_OR_EQUAL = 2;
    public static final int GREATER_THAN = 1;
    public static final int EQUAL = 0;
    public static final int LESS_THAN = -1;
    public static final int LESS_THAN_OR_EQUAL = -2;
    private final Comparator<T> comparator;
    private final T object;
    private final int compareResult;

    public Func1Comparator(Comparator<T> comparator, int compareResult, T object) {
        Preconditions.checkNotNull(comparator, "comparator");
        if (compareResult > 2 || compareResult < -2) {
            throw new IllegalStateException("Invalid compareResult input. Must be any of GREATER_THAN_OR_EQUAL, GREATER_THAN, EQUALLESS_THAN, LESS_THAN_OR_EQUAL");
        }
        this.comparator = comparator;
        this.object = object;
        this.compareResult = compareResult;
    }

    public final Boolean call(T t) {
        int result = this.comparator.compare(t, this.object);
        if (result == 0) {
            return this.compareResult == 0 || this.compareResult == -2 || this.compareResult == 2;
        }
        if (result >= 1) {
            return this.compareResult == 1 || this.compareResult == 2;
        }
        return this.compareResult == -1 || this.compareResult == -2;
    }
}

