/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.views;

import io.reactivesprint.viewmodels.IArrayViewModel;
import io.reactivesprint.viewmodels.IViewModel;
import io.reactivesprint.views.IArrayView;
import io.reactivesprint.views.IArrayViewBinder;
import io.reactivesprint.views.ILifecycleProvider;
import io.reactivesprint.views.ViewBinder;
import io.reactivesprint.views.Views;
import rx.Subscription;
import rx.internal.util.SubscriptionList;

public class ArrayViewBinder<E extends IViewModel, VM extends IArrayViewModel<E>>
extends ViewBinder<VM>
implements IArrayViewBinder<E, VM> {
    public ArrayViewBinder(IArrayView<E, VM> view, ILifecycleProvider<?> lifecycleProvider) {
        super(view, lifecycleProvider);
    }

    @Override
    public IArrayView<E, VM> getView() {
        return (IArrayView)super.getView();
    }

    @Override
    protected SubscriptionList bindViewModel() {
        SubscriptionList subscription = super.bindViewModel();
        IArrayViewModel arrayViewModel = (IArrayViewModel)this.getView().getViewModel();
        if (arrayViewModel == null) {
            return null;
        }
        if (subscription == null) {
            subscription = new SubscriptionList();
        }
        subscription.add(this.bindCount(arrayViewModel));
        subscription.add(this.bindLocalizedEmptyMessage(arrayViewModel));
        subscription.add(this.bindLocalizedEmptyMessageVisibility(arrayViewModel));
        return subscription;
    }

    @Override
    public Subscription bindCount(VM arrayViewModel) {
        return arrayViewModel.count().getObservable().compose(this.bindToLifecycle()).subscribe(Views.onDataSetChanged(this.getView()));
    }

    @Override
    public Subscription bindLocalizedEmptyMessage(VM arrayViewModel) {
        return arrayViewModel.localizedEmptyMessage().getObservable().compose(this.bindToLifecycle()).subscribe(Views.setLocalizedEmptyMessage(this.getView()));
    }

    @Override
    public Subscription bindLocalizedEmptyMessageVisibility(VM arrayViewModel) {
        return arrayViewModel.empty().getObservable().compose(this.bindToLifecycle()).subscribe(Views.setLocalizedEmptyMessageVisibility(this.getView()));
    }
}

