/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller;

import com.github.restup.controller.ExceptionHandler;
import com.github.restup.controller.model.MediaType;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerResponse;
import com.github.restup.errors.DebugRequestError;
import com.github.restup.errors.RequestError;
import com.github.restup.errors.RequestErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    private static volatile DefaultExceptionHandler instance = null;

    private DefaultExceptionHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultExceptionHandler getInstance() {
        if (instance != null) return instance;
        Class<DefaultExceptionHandler> clazz = DefaultExceptionHandler.class;
        synchronized (DefaultExceptionHandler.class) {
            if (instance != null) return instance;
            instance = new DefaultExceptionHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public Object handleException(ResourceControllerRequest request, ResourceControllerResponse response, Throwable e) {
        RequestErrorException result;
        if (e instanceof RequestErrorException) {
            result = (RequestErrorException)e;
            if (log.isDebugEnabled()) {
                for (RequestError err : result.getErrors()) {
                    if (!(err instanceof DebugRequestError)) continue;
                    ((DebugRequestError)err).logStackTrace();
                }
            } else if (result.getHttpStatus() == 500) {
                log.error("An unexpected error occurred. ", e.getCause());
            }
        } else {
            log.error("An unexpected error occurred", e);
            result = new RequestErrorException(e);
        }
        response.setHeader("Content-Type", request != null ? request.getContentType() : MediaType.APPLICATION_JSON.getContentType());
        response.setStatus(result.getHttpStatus());
        return result;
    }
}

