/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restup.controller.ExceptionHandler;
import com.github.restup.controller.content.negotiation.ContentNegotiator;
import com.github.restup.controller.interceptor.RequestInterceptor;
import com.github.restup.controller.linking.LinkBuilderFactory;
import com.github.restup.controller.linking.discovery.ServiceDiscovery;
import com.github.restup.controller.method.DeleteMethodController;
import com.github.restup.controller.method.GetMethodController;
import com.github.restup.controller.method.MethodController;
import com.github.restup.controller.method.PatchMethodController;
import com.github.restup.controller.method.PostMethodController;
import com.github.restup.controller.method.PutMethodController;
import com.github.restup.controller.model.AbstractResourceControllerRequestBuilder;
import com.github.restup.controller.model.HttpHeader;
import com.github.restup.controller.model.HttpMethod;
import com.github.restup.controller.model.MediaType;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerResponse;
import com.github.restup.controller.request.parser.RequestParser;
import com.github.restup.controller.settings.ControllerSettings;
import com.github.restup.errors.RequestError;
import com.github.restup.errors.RequestErrorException;
import com.github.restup.errors.StatusCode;
import com.github.restup.mapping.fields.MappedField;
import com.github.restup.query.criteria.ResourcePathFilter;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRegistry;
import com.github.restup.registry.settings.ControllerMethodAccess;
import com.github.restup.service.model.request.RequestObjectFactory;
import com.github.restup.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    private final ResourceRegistry registry;
    private final ContentNegotiator contentNegotiator;
    private final RequestParser requestParser;
    private final RequestInterceptor interceptor;
    private final ExceptionHandler exceptionHandler;
    private final GetMethodController<?, ?> getController;
    private final DeleteMethodController<?, ?> deleteController;
    private final PatchMethodController<?, ?> patchController;
    private final PostMethodController<?, ?> postController;
    private final PutMethodController<?, ?> putController;

    public ResourceController(ControllerSettings.Builder settings) {
        this(settings.build());
    }

    public ResourceController(ControllerSettings settings) {
        Assert.notNull((Object)settings, (String)"settings are required");
        this.registry = settings.getRegistry();
        this.contentNegotiator = settings.getContentNegotiator();
        this.requestParser = settings.getRequestParser();
        this.interceptor = settings.getRequestInterceptor();
        this.exceptionHandler = settings.getExceptionHandler();
        RequestObjectFactory factory = ResourceController.getFactory(this.registry);
        this.getController = new GetMethodController(factory);
        this.deleteController = new DeleteMethodController(factory);
        this.patchController = new PatchMethodController(factory);
        this.postController = new PostMethodController(factory);
        this.putController = new PutMethodController(factory);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static RequestObjectFactory getFactory(ResourceRegistry registry) {
        return registry.getSettings().getRequestObjectFactory();
    }

    private static <T> void validateData(ParsedResourceControllerRequest<T> parsedRequest, ResourceControllerRequest request, ControllerMethodAccess access, boolean itemOperation, int ids) {
        HttpMethod method = request.getMethod();
        int items = ResourceController.count(parsedRequest.getData());
        if (items == 0) {
            if (method.requiresData()) {
                throw ResourceController.error(request, "DATA_REQUIRED", "Document is required");
            }
        } else {
            if (!method.requiresData()) {
                throw ResourceController.error(request, "DATA_NOT_SUPPORTED", "Document is not supported");
            }
            if (items == 1) {
                if (!itemOperation && !method.supportsCollectionOperation(access)) {
                    throw ResourceController.collectionResourceNotAllowed(request, access);
                }
            } else if (items > 1 && (itemOperation || !method.supportsMultiple(access) || ids > 1)) {
                throw ResourceController.error(request, "DOCUMENT_ARRAY_NOT_SUPPORTED", "Array of documents not supported");
            }
        }
    }

    private static int count(Object data) {
        if (data instanceof Collection) {
            return CollectionUtils.size((Object)data);
        }
        return data == null ? 0 : 1;
    }

    private static void validateIds(ResourceControllerRequest request, ControllerMethodAccess access, int ids) {
        HttpMethod method = request.getMethod();
        if (ids == 1) {
            if (!method.supportsItemOperation(access)) {
                throw ResourceController.itemResourceNotAllowed(request, access);
            }
        } else if (ids > 1) {
            if (!method.supportsAccessByIds(access)) {
                if (!method.supportsItemOperation(access)) {
                    throw ResourceController.itemResourceNotAllowed(request, access);
                }
                throw ResourceController.error(request, "MULTIPLE_IDS_NOT_SUPPORTED", "Multiple ids not supported");
            }
            if (request.getRelationship() != null) {
                throw ResourceController.error(request, "RELATIONSHIP_IDS_NOT_SUPPORTED", "Multiple ids not supported when requesting a relationship");
            }
        } else if (ids == 0 && request.getRelationship() != null) {
            throw ResourceController.error(request, "RELATIONSHIP_ID_REQUIRED", "ID is required when requesting a relationship");
        }
    }

    private static RequestErrorException error(ResourceControllerRequest request, String code, String detail) {
        return ResourceController.error(request).code(code).title("Not supported").detail(detail).buildException();
    }

    private static RequestError.Builder error(ResourceControllerRequest request) {
        return RequestError.builder().resource(request.getResource());
    }

    private static RequestErrorException itemResourceNotAllowed(ResourceControllerRequest request, ControllerMethodAccess access) {
        ArrayList<HttpMethod> supported = new ArrayList<HttpMethod>(HttpMethod.values().length - 1);
        for (HttpMethod m : HttpMethod.values()) {
            if (!m.supportsItemOperation(access)) continue;
            supported.add(m);
        }
        return ResourceController.methodNotAllowed(request, access, supported);
    }

    private static RequestErrorException collectionResourceNotAllowed(ResourceControllerRequest request, ControllerMethodAccess access) {
        ArrayList<HttpMethod> supported = new ArrayList<HttpMethod>(HttpMethod.values().length - 1);
        for (HttpMethod m : HttpMethod.values()) {
            if (!m.supportsCollectionOperation(access)) continue;
            supported.add(m);
        }
        return ResourceController.methodNotAllowed(request, access, supported);
    }

    private static RequestErrorException methodNotAllowed(ResourceControllerRequest request, ControllerMethodAccess access, List<HttpMethod> supported) {
        return ResourceController.error(request).status(StatusCode.METHOD_NOT_ALLOWED).code(StatusCode.METHOD_NOT_ALLOWED.name()).meta(HttpHeader.Allow.name(), supported).buildException();
    }

    private static ControllerMethodAccess getMethodAccess(ResourceRegistry registry, Resource<?, ?> resource) {
        if (resource != null && resource.getControllerMethodAccess() != null) {
            return resource.getControllerMethodAccess();
        }
        return registry.getSettings().getDefaultControllerAccess();
    }

    private static void addUpdateFields(ParsedResourceControllerRequest.Builder<?> builder, List<MappedField<?>> fields) {
        if (builder.getData() instanceof Collection) {
            int i = 0;
            for (Object item : (Collection)builder.getData()) {
                ResourceController.addUpdateFields(builder, fields, i++);
            }
        } else {
            ResourceController.addUpdateFields(builder, fields, null);
        }
    }

    private static void addUpdateFields(ParsedResourceControllerRequest.Builder<?> builder, List<MappedField<?>> fields, Integer i) {
        fields.stream().filter(f -> !f.isImmutable()).map(f -> builder.addRequestedPath(i, (MappedField<?>)f));
    }

    public Object handleException(ResourceControllerRequest request, ResourceControllerResponse response, Throwable e) {
        return this.exceptionHandler.handleException(request, response, e);
    }

    public <T, ID extends Serializable> Object request(AbstractResourceControllerRequestBuilder<?, ?> builder, ResourceControllerResponse response) {
        ResourceControllerRequest request = null;
        try {
            request = (ResourceControllerRequest)builder.build();
            return this.requestInternal(request, response);
        }
        catch (Throwable e) {
            return this.handleException(request, response, e);
        }
    }

    public <T, ID extends Serializable> Object request(ResourceControllerRequest request, ResourceControllerResponse response) {
        try {
            return this.requestInternal(request, response);
        }
        catch (Throwable e) {
            return this.handleException(request, response, e);
        }
    }

    <T, ID extends Serializable> Object requestInternal(ResourceControllerRequest request, ResourceControllerResponse response) {
        Assert.notNull((Object)request, (String)"request is required");
        Assert.notNull((Object)response, (String)"response is required");
        Assert.notNull((Object)((Object)request.getMethod()), (String)"method is required");
        Assert.notNull(request.getResource(), (String)"resource is required");
        ControllerMethodAccess access = ResourceController.getMethodAccess(this.registry, request.getResource());
        int ids = CollectionUtils.size(request.getIds());
        boolean itemOperation = ids == 1;
        this.accept(request);
        MethodController methodController = this.getMethodController(request, access, itemOperation);
        ResourceController.validateIds(request, access, ids);
        ParsedResourceControllerRequest<T> parsedRequest = this.parseRequest(request);
        ResourceController.validateData(parsedRequest, request, access, itemOperation, ids);
        this.interceptor.before(parsedRequest);
        Object result = methodController.request(parsedRequest);
        this.interceptor.after(parsedRequest);
        response.setStatus(methodController.getSuccessStatus());
        return this.contentNegotiator.formatResponse(parsedRequest, response, result);
    }

    private void accept(ResourceControllerRequest request) {
        if (!this.contentNegotiator.accept(request)) {
            throw RequestError.builder(request.getResource()).status(StatusCode.UNSUPPORTED_MEDIA_TYPE).meta("Content-Type", (Object)request.getContentType()).buildException();
        }
    }

    private MethodController getMethodController(ResourceControllerRequest request, ControllerMethodAccess access, boolean itemOperation) {
        switch (request.getMethod()) {
            case GET: {
                return this.getController;
            }
            case PATCH: {
                return this.patchController;
            }
            case POST: {
                return this.postController;
            }
            case PUT: {
                return this.putController;
            }
            case DELETE: {
                return this.deleteController;
            }
        }
        if (itemOperation) {
            throw ResourceController.itemResourceNotAllowed(request, access);
        }
        throw ResourceController.collectionResourceNotAllowed(request, access);
    }

    private <T> ParsedResourceControllerRequest<T> parseRequest(ResourceControllerRequest request) {
        ParsedResourceControllerRequest.Builder builder = ParsedResourceControllerRequest.builder(this.registry, request);
        this.requestParser.parse(request, builder);
        if (CollectionUtils.size(request.getIds()) > 1) {
            MappedField field = request.getResource().getIdentityField();
            builder.addFilter("pathIds", request.getIds(), field.getApiName(), ResourcePathFilter.Operator.in, request.getIds());
        }
        if (HttpMethod.PUT == request.getMethod()) {
            List fields = request.getResource().getMapping().getAttributes();
            ResourceController.addUpdateFields(builder, fields);
        }
        return builder.build();
    }

    public static class Builder {
        ControllerSettings.Builder settings = ControllerSettings.builder();

        private Builder me() {
            return this;
        }

        public Builder registry(ResourceRegistry registry) {
            this.settings.registry(registry);
            return this.me();
        }

        public Builder contentNegotiator(ContentNegotiator contentNegotiator) {
            this.settings.contentNegotiator(contentNegotiator);
            return this.me();
        }

        public Builder contentNegotiator(ContentNegotiator.Builder contentNegotiator) {
            this.settings.contentNegotiator(contentNegotiator);
            return this.me();
        }

        public Builder interceptors(RequestInterceptor ... interceptors) {
            this.settings.interceptors(interceptors);
            return this.me();
        }

        public Builder requestParser(RequestParser requestParser) {
            this.settings.requestParser(requestParser);
            return this.me();
        }

        public Builder requestParser(RequestParser.Builder requestParser) {
            this.settings.requestParser(requestParser);
            return this.me();
        }

        public Builder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.settings.exceptionHandler(exceptionHandler);
            return this.me();
        }

        public Builder linkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
            this.settings.linkBuilderFactory(linkBuilderFactory);
            return this.me();
        }

        public Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.settings.serviceDiscovery(serviceDiscovery);
            return this.me();
        }

        public Builder jacksonObjectMapper(ObjectMapper mapper) {
            this.settings.jacksonObjectMapper(mapper);
            return this.me();
        }

        public Builder autoDetectDisabled(boolean b) {
            this.settings.autoDetectDisabled(b);
            return this.me();
        }

        public Builder defaultMediaType(String mediaType) {
            this.settings.defaultMediaType(mediaType);
            return this.me();
        }

        public Builder defaultMediaType(MediaType mediaType) {
            return this.defaultMediaType(mediaType.getContentType());
        }

        public ResourceController build() {
            return new ResourceController(this.settings);
        }
    }
}

