/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.content.negotiation;

import com.github.restup.controller.content.negotiation.ContentNegotiatorChain;
import com.github.restup.controller.content.negotiation.DefaultContentNegotiator;
import com.github.restup.controller.content.negotiation.JsonApiContentNegotiator;
import com.github.restup.controller.content.negotiation.JsonContentNegotiator;
import com.github.restup.controller.linking.LinkBuilderFactory;
import com.github.restup.controller.linking.discovery.ServiceDiscovery;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerResponse;
import com.github.restup.controller.settings.BuilderSettingsCaptor;
import com.github.restup.registry.settings.AutoDetectConstants;
import org.apache.commons.lang3.ArrayUtils;

public interface ContentNegotiator {
    public static Builder builder() {
        return new Builder();
    }

    public boolean accept(ResourceControllerRequest var1);

    public <T> Object formatResponse(ParsedResourceControllerRequest<T> var1, ResourceControllerResponse var2, Object var3);

    public static class Builder {
        private ContentNegotiator[] contentNegotiators;
        private BuilderSettingsCaptor settingsCaptor = new BuilderSettingsCaptor();

        Builder() {
        }

        Builder me() {
            return this;
        }

        public Builder contentNegotiators(ContentNegotiator ... contentNegotiators) {
            this.contentNegotiators = contentNegotiators;
            return this.me();
        }

        public Builder autoDetectDisabled(boolean autoDetectDisabled) {
            this.settingsCaptor.setAutoDetectDisabled(autoDetectDisabled);
            return this.me();
        }

        public Builder defaultMediaType(String mediaType) {
            this.settingsCaptor.setDefaultMediaType(mediaType);
            return this.me();
        }

        public Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.settingsCaptor.setServiceDiscovery(serviceDiscovery);
            return this.me();
        }

        public Builder linkBuilderFactory(LinkBuilderFactory linkBuilderFactory) {
            this.settingsCaptor.setLinkBuilderFactory(linkBuilderFactory);
            return this.me();
        }

        public Builder capture(BuilderSettingsCaptor settingsCaptor) {
            this.settingsCaptor = settingsCaptor.capture(this.settingsCaptor);
            return this.me();
        }

        public ContentNegotiator build() {
            this.settingsCaptor.build();
            Object[] arr = this.contentNegotiators;
            if (!this.settingsCaptor.getAutoDetectDisabled().booleanValue() && AutoDetectConstants.JACKSON2_EXISTS) {
                arr = (ContentNegotiator[])ArrayUtils.addAll((Object[])arr, (Object[])new ContentNegotiator[]{new JsonContentNegotiator(), new JsonApiContentNegotiator(this.settingsCaptor.getLinkBuilderFactory())});
            }
            if (this.settingsCaptor.getDefaultMediaType() != null) {
                DefaultContentNegotiator defaultContentNegotiator = new DefaultContentNegotiator(this.settingsCaptor.getDefaultMediaType(), (ContentNegotiator[])arr);
                arr = (ContentNegotiator[])ArrayUtils.add((Object[])arr, (Object)defaultContentNegotiator);
            }
            return arr != null ? new ContentNegotiatorChain((ContentNegotiator[])arr) : new ContentNegotiatorChain(new ContentNegotiator[0]);
        }
    }
}

