/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.content.negotiation;

import com.github.restup.controller.content.negotiation.ContentNegotiator;
import com.github.restup.controller.model.MediaType;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerResponse;
import java.util.Objects;

public abstract class ContentTypeNegotiation
implements ContentNegotiator {
    public static final String CONTENT_TYPE = "Content-Type";
    private final String contentType;
    private final String headerValue;

    public ContentTypeNegotiation(MediaType contentType) {
        this(contentType.getContentType());
    }

    public ContentTypeNegotiation(String contentType) {
        this.headerValue = this.contentType = contentType;
    }

    @Override
    public boolean accept(ResourceControllerRequest request) {
        return Objects.equals(request.getContentType(), this.contentType);
    }

    @Override
    public final <T> Object formatResponse(ParsedResourceControllerRequest<T> request, ResourceControllerResponse response, Object result) {
        response.setHeader(CONTENT_TYPE, this.headerValue);
        return this.format(request, response, result);
    }

    abstract Object format(ParsedResourceControllerRequest<?> var1, ResourceControllerResponse var2, Object var3);

    public String getContentType() {
        return this.contentType;
    }
}

