/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.content.negotiation;

import com.github.restup.controller.content.negotiation.ContentNegotiator;
import com.github.restup.controller.content.negotiation.ContentTypeNegotiation;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerResponse;

public class DefaultContentNegotiator
implements ContentNegotiator {
    private ContentNegotiator contentNegotiator;

    public DefaultContentNegotiator(ContentNegotiator contentNegotiator) {
        this.contentNegotiator = contentNegotiator;
    }

    public DefaultContentNegotiator(String mediaType, ContentNegotiator ... negotiators) throws IllegalArgumentException {
        this(DefaultContentNegotiator.getContentNegotiator(mediaType, negotiators));
    }

    static ContentNegotiator getContentNegotiator(String mediaType, ContentNegotiator ... negotiators) {
        for (ContentNegotiator negotiator : negotiators) {
            if (!(negotiator instanceof ContentTypeNegotiation) || !((ContentTypeNegotiation)negotiator).getContentType().equals(mediaType)) continue;
            return negotiator;
        }
        throw new IllegalArgumentException("Negotiator does not exist for  " + mediaType);
    }

    @Override
    public boolean accept(ResourceControllerRequest request) {
        return true;
    }

    @Override
    public <T> Object formatResponse(ParsedResourceControllerRequest<T> request, ResourceControllerResponse response, Object result) {
        return this.contentNegotiator.formatResponse(request, response, result);
    }
}

