/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.interceptor;

import com.github.restup.controller.interceptor.RequestInterceptor;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.util.Assert;

public class RequestInterceptorChain
implements RequestInterceptor {
    private final RequestInterceptor[] interceptors;

    public RequestInterceptorChain(RequestInterceptor ... interceptors) {
        Assert.notEmpty((String)"interceptors are required", (Object[])interceptors);
        this.interceptors = interceptors;
    }

    @Override
    public <T> void before(ParsedResourceControllerRequest<T> request) {
        for (RequestInterceptor interceptor : this.interceptors) {
            interceptor.before(request);
        }
    }

    @Override
    public <T> void after(ParsedResourceControllerRequest<T> request) {
        for (RequestInterceptor interceptor : this.interceptors) {
            interceptor.after(request);
        }
    }
}

