/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.linking;

import com.github.restup.annotations.field.RelationshipType;
import com.github.restup.controller.linking.BasicLink;
import com.github.restup.controller.linking.Link;
import com.github.restup.controller.linking.LinkBuilder;
import com.github.restup.controller.linking.LinkRelations;
import com.github.restup.controller.linking.discovery.ServiceDiscovery;
import com.github.restup.controller.model.HttpMethod;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.registry.Resource;
import com.github.restup.service.model.ResourceData;
import com.github.restup.service.model.response.PagedResult;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLinkBuilder
implements LinkBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultLinkBuilder.class);
    private final ServiceDiscovery serviceDiscovery;

    public DefaultLinkBuilder(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    @Override
    public Link getCollectionEndpoint(ParsedResourceControllerRequest<?> request, Resource<?, ?> resource) {
        String baseUrl = this.serviceDiscovery.locateResourceUrl(request, resource);
        return new BasicLink(resource.getPluralName(), baseUrl);
    }

    @Override
    public List<Link> getLinks(ParsedResourceControllerRequest<?> request, Object result, Resource<?, ?> resource, Object id) {
        if (HttpMethod.DELETE == request.getMethod()) {
            return Collections.emptyList();
        }
        if (request.getRelationship() != null && !this.isIterable(result)) {
            Object rel = this.getId(request);
            return Arrays.asList(this.link(request, LinkRelations.self, request.getRelationship(), rel, resource), this.link(request, LinkRelations.related, request.getRelationship(), rel));
        }
        return Arrays.asList(this.link(request, LinkRelations.self, resource, id));
    }

    @Override
    public List<Link> getRelationshipLinks(ParsedResourceControllerRequest<?> request, Object Result, Resource<?, ?> relationship, Object id) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(this.link(request, LinkRelations.related, request.getResource(), id, relationship));
        return links;
    }

    @Override
    public List<Link> getRelationshipLinks(ParsedResourceControllerRequest<?> request, Object result, Resource<?, ?> relationship, Object id, RelationshipType type) {
        ArrayList<Link> links = new ArrayList<Link>();
        String name = RelationshipType.isToOne((RelationshipType)type) ? relationship.getName() : relationship.getPluralName();
        links.add(this.link(request, LinkRelations.related, request.getResource(), id, name));
        return links;
    }

    @Override
    public List<Link> getTopLevelLinks(ParsedResourceControllerRequest<?> request, Object result) {
        ArrayList<Link> links = new ArrayList<Link>();
        String baseUrl = this.buildResourceRequestBaseUrl(request);
        if (result instanceof PagedResult) {
            PagedResult paged = (PagedResult)result;
            Integer offset = paged.getOffset();
            Integer limit = paged.getLimit();
            if (offset != null && limit != null && limit > 0) {
                if (offset > 0) {
                    this.paging(baseUrl, request, links, LinkRelations.first, 0, limit);
                    this.paging(baseUrl, request, links, LinkRelations.prev, offset - 1, limit);
                }
                this.paging(baseUrl, request, links, LinkRelations.self, offset, limit);
                if (paged.getTotal() != null) {
                    int max = (int)(paged.getTotal() / (long)limit.intValue()) - 1;
                    if (offset < max) {
                        this.paging(baseUrl, request, links, LinkRelations.next, offset + 1, limit);
                        this.paging(baseUrl, request, links, LinkRelations.last, max, limit);
                    }
                } else {
                    this.paging(baseUrl, request, links, LinkRelations.next, offset + 1, limit);
                }
            } else {
                links.add(new BasicLink(LinkRelations.self, baseUrl));
            }
        } else if (this.isIterable(result)) {
            links.add(new BasicLink(LinkRelations.self, baseUrl));
        } else {
            return links;
        }
        if (request.getRelationship() != null) {
            links.add(this.link(request, LinkRelations.related, request.getRelationship(), this.getId(request)));
        }
        return links;
    }

    private boolean isIterable(Object result) {
        return result instanceof ResourceData ? ((ResourceData)result).getData() instanceof Iterable : result instanceof Iterable;
    }

    private void paging(String baseUrl, ParsedResourceControllerRequest<?> request, List<Link> links, LinkRelations rel, int offset, int limit) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        char delimiter = baseUrl.contains("?") ? (char)'&' : '?';
        this.param(sb, delimiter, this.getPageLimitParameterName(request), limit);
        this.param(sb, this.getPageOffsetParameterName(request), offset);
        links.add(new BasicLink(rel, sb.toString()));
    }

    public String buildResourceRequestBaseUrl(ParsedResourceControllerRequest<?> request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getRequestUrl());
        int delimiter = 63;
        List<String> params = request.getAcceptedParameterNames();
        if (params != null) {
            for (String param : params) {
                String[] values;
                if (!this.includeParam(request, param)) continue;
                for (String value : values = request.getParameter(param)) {
                    this.param(sb, (char)delimiter, param, value);
                    delimiter = 38;
                }
            }
        }
        return sb.toString();
    }

    private void param(StringBuilder sb, String param, Integer value) {
        this.param(sb, '&', param, value);
    }

    private void param(StringBuilder sb, char delimiter, String param, Integer value) {
        if (value != null) {
            this.param(sb, delimiter, param, String.valueOf(value));
        }
    }

    private void param(StringBuilder sb, char delimiter, String param, String value) {
        sb.append(delimiter);
        sb.append(param);
        sb.append("=");
        try {
            sb.append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Unable to encode value, using unencoded value in link: " + value, (Throwable)e);
            sb.append(value);
        }
    }

    private boolean includeParam(ParsedResourceControllerRequest<?> request, String param) {
        return !Objects.equals(param, this.getPageLimitParameterName(request)) && !Objects.equals(param, this.getPageOffsetParameterName(request));
    }

    public String getPageLimitParameterName(ParsedResourceControllerRequest<?> request) {
        String result = request.getPageLimitParameterName();
        if (result == null) {
            result = "limit";
        }
        return result;
    }

    public String getPageOffsetParameterName(ParsedResourceControllerRequest<?> request) {
        String result = request.getPageOffsetParameterName();
        if (result == null) {
            result = "offset";
        }
        return result;
    }

    private Link link(ParsedResourceControllerRequest<?> request, LinkRelations rel, Resource<?, ?> resource, Object ... path) {
        return new BasicLink(rel, this.getUrl(request, resource, path));
    }

    private String getUrl(ParsedResourceControllerRequest<?> request, Resource<?, ?> resource, Object ... path) {
        String baseUrl = this.serviceDiscovery.locateResourceUrl(request, resource);
        StringBuilder sb = new StringBuilder();
        sb.append(baseUrl);
        for (Object s : path) {
            sb.append("/").append(s);
        }
        return sb.toString();
    }

    private Object getId(ParsedResourceControllerRequest<?> request) {
        return request.getIds().get(0);
    }
}

