/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.method;

import com.github.restup.controller.method.MethodController;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.path.ResourcePath;
import com.github.restup.registry.Resource;
import com.github.restup.service.model.request.BulkRequest;
import com.github.restup.service.model.request.RequestObjectFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;

abstract class BulkMethodController<T, ID extends Serializable, R>
extends MethodController<T, ID> {
    public BulkMethodController(RequestObjectFactory factory) {
        super(factory);
    }

    abstract R getRequest(Resource<T, ID> var1, T var2, ID var3, ParsedResourceControllerRequest<T> var4);

    boolean isBulk(ParsedResourceControllerRequest<?> request) {
        return request.getData() instanceof Collection && CollectionUtils.size(request.getData()) > 1;
    }

    BulkRequest<R> getIdentifiedBulkRequest(Resource<T, ID> resource, ParsedResourceControllerRequest<T> request) {
        Iterable iterable = (Iterable)request.getData();
        ArrayList<R> list = new ArrayList<R>();
        ResourcePath idPath = ResourcePath.idPath(resource);
        for (Object data : iterable) {
            Object id = idPath.getValue(request.getData());
            list.add(this.getRequest(resource, data, (Serializable)id, request));
        }
        return new BulkRequest(list);
    }

    BulkRequest<R> getBulkRequest(ParsedResourceControllerRequest<T> request) {
        Iterable iterable = (Iterable)request.getData();
        ArrayList<R> list = new ArrayList<R>();
        for (Object data : iterable) {
            list.add(this.getRequest(request.getResource(), data, null, request));
        }
        return new BulkRequest(list);
    }

    R getRequest(ID id, ParsedResourceControllerRequest<T> request) {
        Resource<?, ?> resource = request.getResource();
        return this.getRequest(resource, request.getData(), id, request);
    }
}

