/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.method;

import com.github.restup.controller.method.BulkMethodController;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.registry.Resource;
import com.github.restup.service.ResourceServiceOperations;
import com.github.restup.service.model.request.BulkRequest;
import com.github.restup.service.model.request.DeleteRequest;
import com.github.restup.service.model.request.RequestObjectFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DeleteMethodController<T, ID extends Serializable>
extends BulkMethodController<T, ID, DeleteRequest<T, ID>> {
    public DeleteMethodController(RequestObjectFactory factory) {
        super(factory);
    }

    @Override
    public Object request(ParsedResourceControllerRequest<T> request, Resource<T, ID> resource, ResourceServiceOperations service) {
        int ids = CollectionUtils.size(request.getIds());
        if (ids == 1) {
            Object id = this.getId(request);
            DeleteRequest deleteRequest = (DeleteRequest)this.getRequest(id, request);
            return service.delete(new Object[]{deleteRequest});
        }
        if (ids > 1) {
            BulkRequest<DeleteRequest<T, ID>> deleteRequest = this.getBulkRequestIds(request);
            return service.delete(new Object[]{deleteRequest});
        }
        DeleteRequest deleteRequest = (DeleteRequest)this.getRequest(null, request);
        return service.deleteByQueryCriteria(new Object[]{deleteRequest});
    }

    @Override
    DeleteRequest<T, ID> getRequest(Resource<T, ID> resource, T data, ID id, ParsedResourceControllerRequest<T> request) {
        return this.factory.getDeleteRequest(resource, id, request.getRequestedQueries(), request);
    }

    BulkRequest<DeleteRequest<T, ID>> getBulkRequestIds(ParsedResourceControllerRequest<T> request) {
        List<?> iterable = request.getIds();
        ArrayList list = new ArrayList();
        for (Serializable id : iterable) {
            list.add(this.getRequest(id, request));
        }
        return new BulkRequest(list);
    }
}

