/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.method;

import com.github.restup.controller.method.MethodController;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRelationship;
import com.github.restup.service.ResourceServiceOperations;
import com.github.restup.service.model.request.ListRequest;
import com.github.restup.service.model.request.ReadRequest;
import com.github.restup.service.model.request.RequestObjectFactory;
import com.github.restup.service.model.response.ReadResult;
import com.github.restup.util.UpUtils;
import java.io.Serializable;
import org.apache.commons.collections4.CollectionUtils;

public class GetMethodController<T, ID extends Serializable>
extends MethodController<T, ID> {
    public GetMethodController(RequestObjectFactory factory) {
        super(factory);
    }

    @Override
    public Object request(ParsedResourceControllerRequest<T> request, Resource<T, ID> resource, ResourceServiceOperations service) {
        if (request.getResourceRelationship() != null) {
            return this.findRelationship(request, resource);
        }
        int ids = CollectionUtils.size(request.getIds());
        if (ids == 1) {
            Object id = this.getId(request);
            ReadRequest readRequest = this.factory.getReadRequest(resource, id, request.getRequestedQueries(), request);
            return service.find(new Object[]{readRequest});
        }
        ListRequest readRequest = this.factory.getListRequest(resource, request.getRequestedQueries(), request);
        return service.list(new Object[]{readRequest});
    }

    private Object findRelationship(ParsedResourceControllerRequest<T> request, Resource<T, ID> resource) {
        ResourceRelationship<?, ?, ?, ?> relationship = request.getResourceRelationship();
        ListRequest readRequest = this.factory.getListRequest(resource, request.getRequestedQueries(), request);
        ReadResult result = resource.getService().list(readRequest);
        if (relationship.isToOneRelationship(request.getRelationship())) {
            return ReadResult.of((Object)UpUtils.getFirst((Iterable)((Iterable)result.getData())));
        }
        return result;
    }
}

