/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.model;

import com.github.restup.annotations.field.RelationshipType;
import com.github.restup.bind.converter.ParameterConverter;
import com.github.restup.bind.converter.ParameterConverterFactory;
import com.github.restup.controller.model.HttpMethod;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.errors.Errors;
import com.github.restup.errors.RequestError;
import com.github.restup.errors.RequestErrorException;
import com.github.restup.errors.StatusCode;
import com.github.restup.registry.Resource;
import com.github.restup.registry.ResourceRegistry;
import com.github.restup.registry.ResourceRelationship;
import com.github.restup.service.model.ResourceData;
import com.github.restup.util.Assert;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResourceControllerRequestBuilder<T extends AbstractResourceControllerRequestBuilder<T, R>, R extends ResourceControllerRequest> {
    protected HttpMethod method;
    protected Resource<?, ?> resource;
    protected Resource<?, ?> relationship;
    protected ResourceRelationship<?, ?, ?, ?> resourceRelationship;
    protected List<?> ids;
    protected ResourceData<?> body;
    protected String baseRequestUrl;
    protected String requestPath;
    private ResourceRegistry registry;

    private static String getPath(String[] path, int current) {
        return current >= 0 && current < path.length ? path[current] : null;
    }

    private static RequestErrorException invalidPath(String requestPath) {
        return RequestError.builder().code("INVALID_PATH").detail("{0} is not a valid path", new Object[]{requestPath}).buildException();
    }

    private static RequestErrorException invalidPath(String requestPath, String[] parts) {
        String resourceName;
        int n = 0;
        if (parts.length > 3) {
            n = parts.length - 3;
        }
        if (StringUtils.isBlank((CharSequence)(resourceName = AbstractResourceControllerRequestBuilder.getPath(parts, n)))) {
            resourceName = AbstractResourceControllerRequestBuilder.getPath(parts, n + 1);
        }
        return AbstractResourceControllerRequestBuilder.invalidPath(requestPath, resourceName);
    }

    private static RequestErrorException invalidPath(String requestPath, String resourceName) {
        return RequestError.builder().code("INVALID_RESOURCE_PATH").detail("{0} is not a valid resource", new Object[]{resourceName}).meta("resource", (Object)resourceName).status(StatusCode.NOT_FOUND).buildException();
    }

    private static RequestErrorException invalidRelationship(Resource<?, ?> a, Resource<?, ?> b) {
        return RequestError.builder().code("INVALID_RELATIONSHIP").title("Unknown relationship").detail("Unknown relationship between {0} and {1}", new Object[]{a.getName(), b.getName()}).meta("resource", (Object)a.getName()).meta("requestedRelationship", (Object)b.getName()).buildException();
    }

    private static RequestErrorException invalidRelationship(Resource<?, ?> a, Resource<?, ?> b, boolean toMany) {
        return RequestError.builder().code("INVALID_RELATIONSHIP_TYPE").title("Invalid relationship").detail("Relationship between {0} and {1} exists, but not of requested type. Did you mean to request /{2}", new Object[]{a.getName(), b.getName(), toMany ? b.getName() : b.getPluralName()}).meta("resource", (Object)a.getName()).meta("requestedRelationship", (Object)b.getName()).buildException();
    }

    public abstract R build();

    protected T me() {
        return (T)this;
    }

    public T setRegistry(ResourceRegistry registry) {
        this.registry = registry;
        return this.me();
    }

    public T setBaseRequestUrl(String baseRequestUrl) {
        this.baseRequestUrl = baseRequestUrl;
        return this.me();
    }

    public T setRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this.me();
    }

    public T setBody(ResourceData<?> body) {
        this.body = body;
        return this.me();
    }

    public T setMethod(HttpMethod method) {
        this.method = method;
        return this.me();
    }

    public T setResource(Resource<?, ?> resource) {
        this.resource = resource;
        return this.me();
    }

    public T setRelationship(Resource<?, ?> relationship) {
        this.relationship = relationship;
        return this.me();
    }

    public T setResourceRelationship(ResourceRelationship<?, ?, ?, ?> resourceRelationship) {
        this.resourceRelationship = resourceRelationship;
        return this.me();
    }

    public T setIds(Object ... ids) {
        return this.setIds(Arrays.asList(ids));
    }

    public T setIds(List<?> ids) {
        this.ids = ids;
        return this.me();
    }

    protected boolean isDiscoveryPath(String requestPath) {
        return StringUtils.isBlank((CharSequence)requestPath) || Objects.equals("/", requestPath);
    }

    public void parsePath() {
        Assert.notNull((Object)this.registry, (String)"registry is required");
        String basePath = this.registry.getSettings().getBasePath();
        String path = AbstractResourceControllerRequestBuilder.getPathFromBasePath(basePath, this.requestPath);
        if (this.isDiscoveryPath(path)) {
            this.resource = this.registry.getResource("Up!ResourceDiscovery");
        } else {
            String[] arr = path.split("/");
            int n = arr.length - 1;
            int resourcePathSize = 0;
            String pathZ = AbstractResourceControllerRequestBuilder.getPath(arr, n);
            String pathY = AbstractResourceControllerRequestBuilder.getPath(arr, n - 1);
            Resource resource = this.registry.getResourceByPluralName(pathY);
            Resource relationship = null;
            ResourceRelationship resourceRelationship = null;
            String idString = null;
            if (resource != null) {
                idString = pathZ;
                resourcePathSize = 2;
            } else {
                String pathX = AbstractResourceControllerRequestBuilder.getPath(arr, n - 2);
                resource = this.registry.getResourceByPluralName(pathX);
                if (resource == null) {
                    resource = this.registry.getResourceByPluralName(pathZ);
                    resourcePathSize = 1;
                } else if (n >= 2) {
                    resourcePathSize = 3;
                    idString = pathY;
                    boolean toMany = false;
                    relationship = this.registry.getResource(pathZ);
                    if (relationship == null) {
                        relationship = this.registry.getResourceByPluralName(pathZ);
                        if (relationship == null) {
                            throw AbstractResourceControllerRequestBuilder.invalidPath(this.requestPath, pathZ);
                        }
                        toMany = true;
                    }
                    if ((resourceRelationship = this.registry.getRelationship(resource.getName(), relationship.getName())) == null) {
                        throw AbstractResourceControllerRequestBuilder.invalidRelationship(resource, relationship);
                    }
                    RelationshipType type = resourceRelationship.getType(resource);
                    if (toMany != RelationshipType.isToMany((RelationshipType)type)) {
                        throw AbstractResourceControllerRequestBuilder.invalidRelationship(resource, relationship, toMany);
                    }
                }
            }
            if (resource == null) {
                throw AbstractResourceControllerRequestBuilder.invalidPath(this.requestPath, arr);
            }
            this.setResourceRelationship(resourceRelationship);
            if (relationship != null) {
                ((AbstractResourceControllerRequestBuilder)this.setResource(relationship)).setRelationship(resource);
            } else {
                this.setResource(resource);
            }
            if (idString != null) {
                Type type = resource.getIdentityField().getType();
                String[] ids = idString.split(",");
                ArrayList<Object> list = new ArrayList<Object>(ids.length);
                ParameterConverterFactory f = this.registry.getSettings().getParameterConverterFactory();
                ParameterConverter converter = f.getConverter(type);
                Errors errors = null;
                for (String s : ids) {
                    list.add(converter.convert("ids", (Object)s, errors));
                }
                this.setIds(list);
            }
            if (basePath != null && arr.length != resourcePathSize) {
                throw AbstractResourceControllerRequestBuilder.invalidPath(this.requestPath);
            }
        }
    }

    static String getPathFromBasePath(String basePath, String requestPath) {
        String result = requestPath;
        if (basePath != null) {
            int i = requestPath.indexOf(basePath);
            if (i < 0) {
                if (basePath.length() > 1 && basePath.endsWith("/")) {
                    result = AbstractResourceControllerRequestBuilder.getPathFromBasePath(basePath.substring(0, basePath.length() - 1), requestPath);
                }
            } else {
                result = requestPath.substring(i + basePath.length());
            }
        }
        return result.startsWith("/") ? result.substring(1) : result;
    }
}

