/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.model;

import com.github.restup.controller.model.BasicResourceControllerRequest;
import com.github.restup.controller.model.ParsedResourceControllerRequest;
import com.github.restup.controller.model.ResourceControllerRequest;
import com.github.restup.path.ResourcePath;
import com.github.restup.query.ResourceQueryStatement;
import com.github.restup.service.model.ResourceData;
import com.github.restup.util.UpUtils;
import java.util.Enumeration;
import java.util.List;

class BasicParsedResourceControllerRequest<T>
extends BasicResourceControllerRequest
implements ParsedResourceControllerRequest<T> {
    private final T data;
    private final List<ResourcePath> requestedPaths;
    private final List<ResourceQueryStatement> requestedQueries;
    private final ResourceControllerRequest request;
    private final List<String> acceptedParameterNames;
    private final String pageLimitParameterName;
    private final String pageOffsetParameterName;
    private final boolean pageOffsetOneBased;

    BasicParsedResourceControllerRequest(T data, List<ResourcePath> requestedPaths, List<ResourceQueryStatement> requestedQueries, ResourceControllerRequest request, ResourceData<?> body, List<String> acceptedParameterNames, String pageLimitParameterName, String pageOffsetParameterName, boolean pageOffsetOneBased) {
        super(request.getMethod(), request.getResource(), request.getIds(), request.getRelationship(), request.getResourceRelationship(), body, request.getContentType(), request.getBaseRequestUrl(), request.getRequestUrl());
        this.data = data;
        this.requestedPaths = UpUtils.unmodifiableList(requestedPaths);
        this.requestedQueries = UpUtils.unmodifiableList(requestedQueries);
        this.request = request;
        this.acceptedParameterNames = acceptedParameterNames;
        this.pageLimitParameterName = pageLimitParameterName;
        this.pageOffsetParameterName = pageOffsetParameterName;
        this.pageOffsetOneBased = pageOffsetOneBased;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public List<ResourcePath> getRequestedPaths() {
        return this.requestedPaths;
    }

    @Override
    public List<ResourceQueryStatement> getRequestedQueries() {
        return this.requestedQueries;
    }

    public List<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameter(String parameterName) {
        return this.request.getParameter(parameterName);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.request == null ? null : this.request.getHeaders(name);
    }

    @Override
    public String getPageLimitParameterName() {
        return this.pageLimitParameterName;
    }

    @Override
    public String getPageOffsetParameterName() {
        return this.pageOffsetParameterName;
    }

    @Override
    public List<String> getAcceptedParameterNames() {
        return this.acceptedParameterNames;
    }

    @Override
    public boolean isPageOffsetOneBased() {
        return this.pageOffsetOneBased;
    }

    public ResourceControllerRequest getRequest() {
        return this.request;
    }
}

