/*
 * Decompiled with CFR 0.152.
 */
package com.github.restup.controller.model;

import com.github.restup.registry.settings.ControllerMethodAccess;

public enum HttpMethod {
    GET,
    POST,
    PATCH,
    PUT,
    DELETE,
    OPTIONS;


    public static HttpMethod of(String method) {
        if (method != null) {
            for (HttpMethod m : HttpMethod.values()) {
                if (!m.name().equalsIgnoreCase(method)) continue;
                return m;
            }
        }
        return null;
    }

    public boolean supportsAccessByIds(ControllerMethodAccess access) {
        switch (this) {
            case GET: {
                return !access.isGetByIdsDisabled();
            }
            case PATCH: {
                return !access.isPatchByIdsDisabled();
            }
            case DELETE: {
                return !access.isDeleteByIdsDisabled();
            }
        }
        return false;
    }

    public boolean supportsItemOperation(ControllerMethodAccess access) {
        switch (this) {
            case GET: {
                return !access.isGetByIdDisabled();
            }
            case PATCH: {
                return !access.isPatchByIdDisabled();
            }
            case DELETE: {
                return !access.isDeleteByIdDisabled();
            }
            case PUT: {
                return !access.isUpdateByIdDisabled();
            }
        }
        return false;
    }

    public boolean supportsCollectionOperation(ControllerMethodAccess access) {
        switch (this) {
            case GET: {
                return !access.isListDisabled();
            }
            case POST: {
                return !access.isCreateDisabled();
            }
            case PATCH: {
                return !access.isPatchByQueryDisabled();
            }
            case DELETE: {
                return !access.isDeleteByQueryDisabled();
            }
        }
        return false;
    }

    public boolean supportsMultiple(ControllerMethodAccess access) {
        switch (this) {
            case PATCH: {
                return !access.isPatchMultipleDisabled();
            }
            case POST: {
                return !access.isCreateMultipleDisabled();
            }
            case PUT: {
                return !access.isUpdateMultipleDisabled();
            }
        }
        return false;
    }

    public boolean requiresData() {
        switch (this) {
            case PATCH: {
                return true;
            }
            case POST: {
                return true;
            }
            case PUT: {
                return true;
            }
        }
        return false;
    }
}

